package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetSnapshotsResponse(
    snapShotTimeFilter: Option[zio.aws.kendra.model.TimeRange] = None,
    snapshotsDataHeader: Option[Iterable[String]] = None,
    snapshotsData: Option[Iterable[Iterable[String]]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.GetSnapshotsResponse = {
    import GetSnapshotsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.GetSnapshotsResponse
      .builder()
      .optionallyWith(snapShotTimeFilter.map(value => value.buildAwsValue()))(
        _.snapShotTimeFilter
      )
      .optionallyWith(
        snapshotsDataHeader.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.snapshotsDataHeader)
      .optionallyWith(
        snapshotsData.map(value =>
          value.map { item =>
            item.map { item =>
              item: java.lang.String
            }.asJavaCollection
          }.asJavaCollection
        )
      )(_.snapshotsData)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.GetSnapshotsResponse.ReadOnly =
    zio.aws.kendra.model.GetSnapshotsResponse.wrap(buildAwsValue())
}
object GetSnapshotsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.GetSnapshotsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.GetSnapshotsResponse =
      zio.aws.kendra.model.GetSnapshotsResponse(
        snapShotTimeFilter.map(value => value.asEditable),
        snapshotsDataHeader.map(value => value),
        snapshotsData.map(value => value),
        nextToken.map(value => value)
      )
    def snapShotTimeFilter: Option[zio.aws.kendra.model.TimeRange.ReadOnly]
    def snapshotsDataHeader: Option[List[String]]
    def snapshotsData: Option[List[List[String]]]
    def nextToken: Option[NextToken]
    def getSnapShotTimeFilter
        : ZIO[Any, AwsError, zio.aws.kendra.model.TimeRange.ReadOnly] =
      AwsError.unwrapOptionField("snapShotTimeFilter", snapShotTimeFilter)
    def getSnapshotsDataHeader: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("snapshotsDataHeader", snapshotsDataHeader)
    def getSnapshotsData: ZIO[Any, AwsError, List[List[String]]] =
      AwsError.unwrapOptionField("snapshotsData", snapshotsData)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.GetSnapshotsResponse
  ) extends zio.aws.kendra.model.GetSnapshotsResponse.ReadOnly {
    override val snapShotTimeFilter
        : Option[zio.aws.kendra.model.TimeRange.ReadOnly] = scala
      .Option(impl.snapShotTimeFilter())
      .map(value => zio.aws.kendra.model.TimeRange.wrap(value))
    override val snapshotsDataHeader: Option[List[String]] = scala
      .Option(impl.snapshotsDataHeader())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val snapshotsData: Option[List[List[String]]] = scala
      .Option(impl.snapshotsData())
      .map(value =>
        value.asScala.map { item =>
          item.asScala.map { item =>
            item: String
          }.toList
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.kendra.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.GetSnapshotsResponse
  ): zio.aws.kendra.model.GetSnapshotsResponse.ReadOnly = new Wrapper(impl)
}
