package zio.aws.kendra.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GroupMembers(
    memberGroups: Option[Iterable[zio.aws.kendra.model.MemberGroup]] = None,
    memberUsers: Option[Iterable[zio.aws.kendra.model.MemberUser]] = None,
    s3PathforGroupMembers: Option[zio.aws.kendra.model.S3Path] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.GroupMembers = {
    import GroupMembers.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.GroupMembers
      .builder()
      .optionallyWith(
        memberGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.memberGroups)
      .optionallyWith(
        memberUsers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.memberUsers)
      .optionallyWith(
        s3PathforGroupMembers.map(value => value.buildAwsValue())
      )(_.s3PathforGroupMembers)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.GroupMembers.ReadOnly =
    zio.aws.kendra.model.GroupMembers.wrap(buildAwsValue())
}
object GroupMembers {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.GroupMembers
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.GroupMembers =
      zio.aws.kendra.model.GroupMembers(
        memberGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        memberUsers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        s3PathforGroupMembers.map(value => value.asEditable)
      )
    def memberGroups: Option[List[zio.aws.kendra.model.MemberGroup.ReadOnly]]
    def memberUsers: Option[List[zio.aws.kendra.model.MemberUser.ReadOnly]]
    def s3PathforGroupMembers: Option[zio.aws.kendra.model.S3Path.ReadOnly]
    def getMemberGroups
        : ZIO[Any, AwsError, List[zio.aws.kendra.model.MemberGroup.ReadOnly]] =
      AwsError.unwrapOptionField("memberGroups", memberGroups)
    def getMemberUsers
        : ZIO[Any, AwsError, List[zio.aws.kendra.model.MemberUser.ReadOnly]] =
      AwsError.unwrapOptionField("memberUsers", memberUsers)
    def getS3PathforGroupMembers
        : ZIO[Any, AwsError, zio.aws.kendra.model.S3Path.ReadOnly] =
      AwsError.unwrapOptionField("s3PathforGroupMembers", s3PathforGroupMembers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.GroupMembers
  ) extends zio.aws.kendra.model.GroupMembers.ReadOnly {
    override val memberGroups
        : Option[List[zio.aws.kendra.model.MemberGroup.ReadOnly]] = scala
      .Option(impl.memberGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.MemberGroup.wrap(item)
        }.toList
      )
    override val memberUsers
        : Option[List[zio.aws.kendra.model.MemberUser.ReadOnly]] = scala
      .Option(impl.memberUsers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.MemberUser.wrap(item)
        }.toList
      )
    override val s3PathforGroupMembers
        : Option[zio.aws.kendra.model.S3Path.ReadOnly] = scala
      .Option(impl.s3PathforGroupMembers())
      .map(value => zio.aws.kendra.model.S3Path.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.GroupMembers
  ): zio.aws.kendra.model.GroupMembers.ReadOnly = new Wrapper(impl)
}
