package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  FailureReason,
  PrincipalOrderingId,
  Timestamp
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class GroupOrderingIdSummary(
    status: Option[zio.aws.kendra.model.PrincipalMappingStatus] = None,
    lastUpdatedAt: Option[Timestamp] = None,
    receivedAt: Option[Timestamp] = None,
    orderingId: Option[PrincipalOrderingId] = None,
    failureReason: Option[FailureReason] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.GroupOrderingIdSummary = {
    import GroupOrderingIdSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.GroupOrderingIdSummary
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        lastUpdatedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .optionallyWith(
        receivedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.receivedAt)
      .optionallyWith(
        orderingId.map(value =>
          PrincipalOrderingId.unwrap(value): java.lang.Long
        )
      )(_.orderingId)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.GroupOrderingIdSummary.ReadOnly =
    zio.aws.kendra.model.GroupOrderingIdSummary.wrap(buildAwsValue())
}
object GroupOrderingIdSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.GroupOrderingIdSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.GroupOrderingIdSummary =
      zio.aws.kendra.model.GroupOrderingIdSummary(
        status.map(value => value),
        lastUpdatedAt.map(value => value),
        receivedAt.map(value => value),
        orderingId.map(value => value),
        failureReason.map(value => value)
      )
    def status: Option[zio.aws.kendra.model.PrincipalMappingStatus]
    def lastUpdatedAt: Option[Timestamp]
    def receivedAt: Option[Timestamp]
    def orderingId: Option[PrincipalOrderingId]
    def failureReason: Option[FailureReason]
    def getStatus
        : ZIO[Any, AwsError, zio.aws.kendra.model.PrincipalMappingStatus] =
      AwsError.unwrapOptionField("status", status)
    def getLastUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getReceivedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("receivedAt", receivedAt)
    def getOrderingId: ZIO[Any, AwsError, PrincipalOrderingId] =
      AwsError.unwrapOptionField("orderingId", orderingId)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.GroupOrderingIdSummary
  ) extends zio.aws.kendra.model.GroupOrderingIdSummary.ReadOnly {
    override val status: Option[zio.aws.kendra.model.PrincipalMappingStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.kendra.model.PrincipalMappingStatus.wrap(value))
    override val lastUpdatedAt: Option[Timestamp] = scala
      .Option(impl.lastUpdatedAt())
      .map(value => zio.aws.kendra.model.primitives.Timestamp(value))
    override val receivedAt: Option[Timestamp] = scala
      .Option(impl.receivedAt())
      .map(value => zio.aws.kendra.model.primitives.Timestamp(value))
    override val orderingId: Option[PrincipalOrderingId] = scala
      .Option(impl.orderingId())
      .map(value => zio.aws.kendra.model.primitives.PrincipalOrderingId(value))
    override val failureReason: Option[FailureReason] = scala
      .Option(impl.failureReason())
      .map(value => zio.aws.kendra.model.primitives.FailureReason(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.GroupOrderingIdSummary
  ): zio.aws.kendra.model.GroupOrderingIdSummary.ReadOnly = new Wrapper(impl)
}
