package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.Integer
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Highlight(
    beginOffset: Integer,
    endOffset: Integer,
    topAnswer: Option[Boolean] = None,
    `type`: Option[zio.aws.kendra.model.HighlightType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.Highlight = {
    import Highlight.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.Highlight
      .builder()
      .beginOffset(beginOffset: java.lang.Integer)
      .endOffset(endOffset: java.lang.Integer)
      .optionallyWith(topAnswer.map(value => value: java.lang.Boolean))(
        _.topAnswer
      )
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.Highlight.ReadOnly =
    zio.aws.kendra.model.Highlight.wrap(buildAwsValue())
}
object Highlight {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kendra.model.Highlight] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.Highlight =
      zio.aws.kendra.model.Highlight(
        beginOffset,
        endOffset,
        topAnswer.map(value => value),
        `type`.map(value => value)
      )
    def beginOffset: Integer
    def endOffset: Integer
    def topAnswer: Option[Boolean]
    def `type`: Option[zio.aws.kendra.model.HighlightType]
    def getBeginOffset: ZIO[Any, Nothing, Integer] = ZIO.succeed(beginOffset)
    def getEndOffset: ZIO[Any, Nothing, Integer] = ZIO.succeed(endOffset)
    def getTopAnswer: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("topAnswer", topAnswer)
    def getType: ZIO[Any, AwsError, zio.aws.kendra.model.HighlightType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.Highlight
  ) extends zio.aws.kendra.model.Highlight.ReadOnly {
    override val beginOffset: Integer = impl.beginOffset(): Integer
    override val endOffset: Integer = impl.endOffset(): Integer
    override val topAnswer: Option[Boolean] =
      scala.Option(impl.topAnswer()).map(value => value: Boolean)
    override val `type`: Option[zio.aws.kendra.model.HighlightType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.kendra.model.HighlightType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.Highlight
  ): zio.aws.kendra.model.Highlight.ReadOnly = new Wrapper(impl)
}
