package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{S3BucketName, LambdaArn}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class HookConfiguration(
    invocationCondition: Option[
      zio.aws.kendra.model.DocumentAttributeCondition
    ] = None,
    lambdaArn: LambdaArn,
    s3Bucket: S3BucketName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.HookConfiguration = {
    import HookConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.HookConfiguration
      .builder()
      .optionallyWith(invocationCondition.map(value => value.buildAwsValue()))(
        _.invocationCondition
      )
      .lambdaArn(LambdaArn.unwrap(lambdaArn): java.lang.String)
      .s3Bucket(S3BucketName.unwrap(s3Bucket): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.HookConfiguration.ReadOnly =
    zio.aws.kendra.model.HookConfiguration.wrap(buildAwsValue())
}
object HookConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.HookConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.HookConfiguration =
      zio.aws.kendra.model.HookConfiguration(
        invocationCondition.map(value => value.asEditable),
        lambdaArn,
        s3Bucket
      )
    def invocationCondition
        : Option[zio.aws.kendra.model.DocumentAttributeCondition.ReadOnly]
    def lambdaArn: LambdaArn
    def s3Bucket: S3BucketName
    def getInvocationCondition: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.DocumentAttributeCondition.ReadOnly
    ] = AwsError.unwrapOptionField("invocationCondition", invocationCondition)
    def getLambdaArn: ZIO[Any, Nothing, LambdaArn] = ZIO.succeed(lambdaArn)
    def getS3Bucket: ZIO[Any, Nothing, S3BucketName] = ZIO.succeed(s3Bucket)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.HookConfiguration
  ) extends zio.aws.kendra.model.HookConfiguration.ReadOnly {
    override val invocationCondition
        : Option[zio.aws.kendra.model.DocumentAttributeCondition.ReadOnly] =
      scala
        .Option(impl.invocationCondition())
        .map(value =>
          zio.aws.kendra.model.DocumentAttributeCondition.wrap(value)
        )
    override val lambdaArn: LambdaArn =
      zio.aws.kendra.model.primitives.LambdaArn(impl.lambdaArn())
    override val s3Bucket: S3BucketName =
      zio.aws.kendra.model.primitives.S3BucketName(impl.s3Bucket())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.HookConfiguration
  ): zio.aws.kendra.model.HookConfiguration.ReadOnly = new Wrapper(impl)
}
