package zio.aws.kendra.model
import scala.jdk.CollectionConverters._
sealed trait IndexStatus {
  def unwrap: software.amazon.awssdk.services.kendra.model.IndexStatus
}
object IndexStatus {
  def wrap(
      value: software.amazon.awssdk.services.kendra.model.IndexStatus
  ): zio.aws.kendra.model.IndexStatus = value match {
    case software.amazon.awssdk.services.kendra.model.IndexStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kendra.model.IndexStatus.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.kendra.model.IndexStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.kendra.model.IndexStatus.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.kendra.model.IndexStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.kendra.model.IndexStatus.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.kendra.model.IndexStatus.SYSTEM_UPDATING =>
      val r = SYSTEM_UPDATING
      r
  }
  case object unknownToSdkVersion extends zio.aws.kendra.model.IndexStatus {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.IndexStatus =
      software.amazon.awssdk.services.kendra.model.IndexStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.kendra.model.IndexStatus {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.IndexStatus =
      software.amazon.awssdk.services.kendra.model.IndexStatus.CREATING
  }
  case object ACTIVE extends zio.aws.kendra.model.IndexStatus {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.IndexStatus =
      software.amazon.awssdk.services.kendra.model.IndexStatus.ACTIVE
  }
  case object DELETING extends zio.aws.kendra.model.IndexStatus {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.IndexStatus =
      software.amazon.awssdk.services.kendra.model.IndexStatus.DELETING
  }
  case object FAILED extends zio.aws.kendra.model.IndexStatus {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.IndexStatus =
      software.amazon.awssdk.services.kendra.model.IndexStatus.FAILED
  }
  case object UPDATING extends zio.aws.kendra.model.IndexStatus {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.IndexStatus =
      software.amazon.awssdk.services.kendra.model.IndexStatus.UPDATING
  }
  case object SYSTEM_UPDATING extends zio.aws.kendra.model.IndexStatus {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.IndexStatus =
      software.amazon.awssdk.services.kendra.model.IndexStatus.SYSTEM_UPDATING
  }
}
