package zio.aws.kendra.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InlineCustomDocumentEnrichmentConfiguration(
    condition: Option[zio.aws.kendra.model.DocumentAttributeCondition] = None,
    target: Option[zio.aws.kendra.model.DocumentAttributeTarget] = None,
    documentContentDeletion: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.InlineCustomDocumentEnrichmentConfiguration = {
    import InlineCustomDocumentEnrichmentConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.InlineCustomDocumentEnrichmentConfiguration
      .builder()
      .optionallyWith(condition.map(value => value.buildAwsValue()))(
        _.condition
      )
      .optionallyWith(target.map(value => value.buildAwsValue()))(_.target)
      .optionallyWith(
        documentContentDeletion.map(value => value: java.lang.Boolean)
      )(_.documentContentDeletion)
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.InlineCustomDocumentEnrichmentConfiguration.ReadOnly =
    zio.aws.kendra.model.InlineCustomDocumentEnrichmentConfiguration
      .wrap(buildAwsValue())
}
object InlineCustomDocumentEnrichmentConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.InlineCustomDocumentEnrichmentConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kendra.model.InlineCustomDocumentEnrichmentConfiguration =
      zio.aws.kendra.model.InlineCustomDocumentEnrichmentConfiguration(
        condition.map(value => value.asEditable),
        target.map(value => value.asEditable),
        documentContentDeletion.map(value => value)
      )
    def condition
        : Option[zio.aws.kendra.model.DocumentAttributeCondition.ReadOnly]
    def target: Option[zio.aws.kendra.model.DocumentAttributeTarget.ReadOnly]
    def documentContentDeletion: Option[Boolean]
    def getCondition: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.DocumentAttributeCondition.ReadOnly
    ] = AwsError.unwrapOptionField("condition", condition)
    def getTarget: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.DocumentAttributeTarget.ReadOnly
    ] = AwsError.unwrapOptionField("target", target)
    def getDocumentContentDeletion: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("documentContentDeletion", documentContentDeletion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.InlineCustomDocumentEnrichmentConfiguration
  ) extends zio.aws.kendra.model.InlineCustomDocumentEnrichmentConfiguration.ReadOnly {
    override val condition
        : Option[zio.aws.kendra.model.DocumentAttributeCondition.ReadOnly] =
      scala
        .Option(impl.condition())
        .map(value =>
          zio.aws.kendra.model.DocumentAttributeCondition.wrap(value)
        )
    override val target
        : Option[zio.aws.kendra.model.DocumentAttributeTarget.ReadOnly] = scala
      .Option(impl.target())
      .map(value => zio.aws.kendra.model.DocumentAttributeTarget.wrap(value))
    override val documentContentDeletion: Option[Boolean] =
      scala.Option(impl.documentContentDeletion()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.InlineCustomDocumentEnrichmentConfiguration
  ): zio.aws.kendra.model.InlineCustomDocumentEnrichmentConfiguration.ReadOnly =
    new Wrapper(impl)
}
