package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  RoleArn,
  Url,
  Issuer,
  GroupAttributeField,
  ClaimRegex,
  UserNameAttributeField
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class JwtTokenTypeConfiguration(
    keyLocation: zio.aws.kendra.model.KeyLocation,
    url: Option[Url] = None,
    secretManagerArn: Option[RoleArn] = None,
    userNameAttributeField: Option[UserNameAttributeField] = None,
    groupAttributeField: Option[GroupAttributeField] = None,
    issuer: Option[Issuer] = None,
    claimRegex: Option[ClaimRegex] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.JwtTokenTypeConfiguration = {
    import JwtTokenTypeConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.JwtTokenTypeConfiguration
      .builder()
      .keyLocation(keyLocation.unwrap)
      .optionallyWith(url.map(value => Url.unwrap(value): java.lang.String))(
        _.url
      )
      .optionallyWith(
        secretManagerArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.secretManagerArn)
      .optionallyWith(
        userNameAttributeField.map(value =>
          UserNameAttributeField.unwrap(value): java.lang.String
        )
      )(_.userNameAttributeField)
      .optionallyWith(
        groupAttributeField.map(value =>
          GroupAttributeField.unwrap(value): java.lang.String
        )
      )(_.groupAttributeField)
      .optionallyWith(
        issuer.map(value => Issuer.unwrap(value): java.lang.String)
      )(_.issuer)
      .optionallyWith(
        claimRegex.map(value => ClaimRegex.unwrap(value): java.lang.String)
      )(_.claimRegex)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.JwtTokenTypeConfiguration.ReadOnly =
    zio.aws.kendra.model.JwtTokenTypeConfiguration.wrap(buildAwsValue())
}
object JwtTokenTypeConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.JwtTokenTypeConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.JwtTokenTypeConfiguration =
      zio.aws.kendra.model.JwtTokenTypeConfiguration(
        keyLocation,
        url.map(value => value),
        secretManagerArn.map(value => value),
        userNameAttributeField.map(value => value),
        groupAttributeField.map(value => value),
        issuer.map(value => value),
        claimRegex.map(value => value)
      )
    def keyLocation: zio.aws.kendra.model.KeyLocation
    def url: Option[Url]
    def secretManagerArn: Option[RoleArn]
    def userNameAttributeField: Option[UserNameAttributeField]
    def groupAttributeField: Option[GroupAttributeField]
    def issuer: Option[Issuer]
    def claimRegex: Option[ClaimRegex]
    def getKeyLocation: ZIO[Any, Nothing, zio.aws.kendra.model.KeyLocation] =
      ZIO.succeed(keyLocation)
    def getUrl: ZIO[Any, AwsError, Url] = AwsError.unwrapOptionField("url", url)
    def getSecretManagerArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("secretManagerArn", secretManagerArn)
    def getUserNameAttributeField: ZIO[Any, AwsError, UserNameAttributeField] =
      AwsError.unwrapOptionField(
        "userNameAttributeField",
        userNameAttributeField
      )
    def getGroupAttributeField: ZIO[Any, AwsError, GroupAttributeField] =
      AwsError.unwrapOptionField("groupAttributeField", groupAttributeField)
    def getIssuer: ZIO[Any, AwsError, Issuer] =
      AwsError.unwrapOptionField("issuer", issuer)
    def getClaimRegex: ZIO[Any, AwsError, ClaimRegex] =
      AwsError.unwrapOptionField("claimRegex", claimRegex)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.JwtTokenTypeConfiguration
  ) extends zio.aws.kendra.model.JwtTokenTypeConfiguration.ReadOnly {
    override val keyLocation: zio.aws.kendra.model.KeyLocation =
      zio.aws.kendra.model.KeyLocation.wrap(impl.keyLocation())
    override val url: Option[Url] = scala
      .Option(impl.url())
      .map(value => zio.aws.kendra.model.primitives.Url(value))
    override val secretManagerArn: Option[RoleArn] = scala
      .Option(impl.secretManagerArn())
      .map(value => zio.aws.kendra.model.primitives.RoleArn(value))
    override val userNameAttributeField: Option[UserNameAttributeField] = scala
      .Option(impl.userNameAttributeField())
      .map(value =>
        zio.aws.kendra.model.primitives.UserNameAttributeField(value)
      )
    override val groupAttributeField: Option[GroupAttributeField] = scala
      .Option(impl.groupAttributeField())
      .map(value => zio.aws.kendra.model.primitives.GroupAttributeField(value))
    override val issuer: Option[Issuer] = scala
      .Option(impl.issuer())
      .map(value => zio.aws.kendra.model.primitives.Issuer(value))
    override val claimRegex: Option[ClaimRegex] = scala
      .Option(impl.claimRegex())
      .map(value => zio.aws.kendra.model.primitives.ClaimRegex(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.JwtTokenTypeConfiguration
  ): zio.aws.kendra.model.JwtTokenTypeConfiguration.ReadOnly = new Wrapper(impl)
}
