package zio.aws.kendra.model
import java.lang.Integer
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  MaxResultsIntegerForListDataSourceSyncJobsRequest,
  NextToken,
  IndexId,
  DataSourceId
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListDataSourceSyncJobsRequest(
    id: DataSourceId,
    indexId: IndexId,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResultsIntegerForListDataSourceSyncJobsRequest] =
      None,
    startTimeFilter: Option[zio.aws.kendra.model.TimeRange] = None,
    statusFilter: Option[zio.aws.kendra.model.DataSourceSyncJobStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.ListDataSourceSyncJobsRequest = {
    import ListDataSourceSyncJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.ListDataSourceSyncJobsRequest
      .builder()
      .id(DataSourceId.unwrap(id): java.lang.String)
      .indexId(IndexId.unwrap(indexId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value =>
          MaxResultsIntegerForListDataSourceSyncJobsRequest.unwrap(
            value
          ): Integer
        )
      )(_.maxResults)
      .optionallyWith(startTimeFilter.map(value => value.buildAwsValue()))(
        _.startTimeFilter
      )
      .optionallyWith(statusFilter.map(value => value.unwrap))(_.statusFilter)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.ListDataSourceSyncJobsRequest.ReadOnly =
    zio.aws.kendra.model.ListDataSourceSyncJobsRequest.wrap(buildAwsValue())
}
object ListDataSourceSyncJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.ListDataSourceSyncJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.ListDataSourceSyncJobsRequest =
      zio.aws.kendra.model.ListDataSourceSyncJobsRequest(
        id,
        indexId,
        nextToken.map(value => value),
        maxResults.map(value => value),
        startTimeFilter.map(value => value.asEditable),
        statusFilter.map(value => value)
      )
    def id: DataSourceId
    def indexId: IndexId
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResultsIntegerForListDataSourceSyncJobsRequest]
    def startTimeFilter: Option[zio.aws.kendra.model.TimeRange.ReadOnly]
    def statusFilter: Option[zio.aws.kendra.model.DataSourceSyncJobStatus]
    def getId: ZIO[Any, Nothing, DataSourceId] = ZIO.succeed(id)
    def getIndexId: ZIO[Any, Nothing, IndexId] = ZIO.succeed(indexId)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[
      Any,
      AwsError,
      MaxResultsIntegerForListDataSourceSyncJobsRequest
    ] = AwsError.unwrapOptionField("maxResults", maxResults)
    def getStartTimeFilter
        : ZIO[Any, AwsError, zio.aws.kendra.model.TimeRange.ReadOnly] =
      AwsError.unwrapOptionField("startTimeFilter", startTimeFilter)
    def getStatusFilter
        : ZIO[Any, AwsError, zio.aws.kendra.model.DataSourceSyncJobStatus] =
      AwsError.unwrapOptionField("statusFilter", statusFilter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.ListDataSourceSyncJobsRequest
  ) extends zio.aws.kendra.model.ListDataSourceSyncJobsRequest.ReadOnly {
    override val id: DataSourceId =
      zio.aws.kendra.model.primitives.DataSourceId(impl.id())
    override val indexId: IndexId =
      zio.aws.kendra.model.primitives.IndexId(impl.indexId())
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.kendra.model.primitives.NextToken(value))
    override val maxResults
        : Option[MaxResultsIntegerForListDataSourceSyncJobsRequest] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.kendra.model.primitives
          .MaxResultsIntegerForListDataSourceSyncJobsRequest(value)
      )
    override val startTimeFilter
        : Option[zio.aws.kendra.model.TimeRange.ReadOnly] = scala
      .Option(impl.startTimeFilter())
      .map(value => zio.aws.kendra.model.TimeRange.wrap(value))
    override val statusFilter
        : Option[zio.aws.kendra.model.DataSourceSyncJobStatus] = scala
      .Option(impl.statusFilter())
      .map(value => zio.aws.kendra.model.DataSourceSyncJobStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.ListDataSourceSyncJobsRequest
  ): zio.aws.kendra.model.ListDataSourceSyncJobsRequest.ReadOnly = new Wrapper(
    impl
  )
}
