package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListDataSourceSyncJobsResponse(
    history: Option[Iterable[zio.aws.kendra.model.DataSourceSyncJob]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.ListDataSourceSyncJobsResponse = {
    import ListDataSourceSyncJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.ListDataSourceSyncJobsResponse
      .builder()
      .optionallyWith(
        history.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.history)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.ListDataSourceSyncJobsResponse.ReadOnly =
    zio.aws.kendra.model.ListDataSourceSyncJobsResponse.wrap(buildAwsValue())
}
object ListDataSourceSyncJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.ListDataSourceSyncJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.ListDataSourceSyncJobsResponse =
      zio.aws.kendra.model.ListDataSourceSyncJobsResponse(
        history.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def history: Option[List[zio.aws.kendra.model.DataSourceSyncJob.ReadOnly]]
    def nextToken: Option[NextToken]
    def getHistory: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.DataSourceSyncJob.ReadOnly
    ]] = AwsError.unwrapOptionField("history", history)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.ListDataSourceSyncJobsResponse
  ) extends zio.aws.kendra.model.ListDataSourceSyncJobsResponse.ReadOnly {
    override val history
        : Option[List[zio.aws.kendra.model.DataSourceSyncJob.ReadOnly]] = scala
      .Option(impl.history())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.DataSourceSyncJob.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.kendra.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.ListDataSourceSyncJobsResponse
  ): zio.aws.kendra.model.ListDataSourceSyncJobsResponse.ReadOnly = new Wrapper(
    impl
  )
}
