package zio.aws.kendra.model
import java.lang.Integer
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  MaxResultsIntegerForListDataSourcesRequest,
  NextToken,
  IndexId
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListDataSourcesRequest(
    indexId: IndexId,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResultsIntegerForListDataSourcesRequest] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.ListDataSourcesRequest = {
    import ListDataSourcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.ListDataSourcesRequest
      .builder()
      .indexId(IndexId.unwrap(indexId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value =>
          MaxResultsIntegerForListDataSourcesRequest.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.ListDataSourcesRequest.ReadOnly =
    zio.aws.kendra.model.ListDataSourcesRequest.wrap(buildAwsValue())
}
object ListDataSourcesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.ListDataSourcesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.ListDataSourcesRequest =
      zio.aws.kendra.model.ListDataSourcesRequest(
        indexId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def indexId: IndexId
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResultsIntegerForListDataSourcesRequest]
    def getIndexId: ZIO[Any, Nothing, IndexId] = ZIO.succeed(indexId)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults
        : ZIO[Any, AwsError, MaxResultsIntegerForListDataSourcesRequest] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.ListDataSourcesRequest
  ) extends zio.aws.kendra.model.ListDataSourcesRequest.ReadOnly {
    override val indexId: IndexId =
      zio.aws.kendra.model.primitives.IndexId(impl.indexId())
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.kendra.model.primitives.NextToken(value))
    override val maxResults
        : Option[MaxResultsIntegerForListDataSourcesRequest] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.kendra.model.primitives
          .MaxResultsIntegerForListDataSourcesRequest(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.ListDataSourcesRequest
  ): zio.aws.kendra.model.ListDataSourcesRequest.ReadOnly = new Wrapper(impl)
}
