package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListDataSourcesResponse(
    summaryItems: Option[Iterable[zio.aws.kendra.model.DataSourceSummary]] =
      None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.ListDataSourcesResponse = {
    import ListDataSourcesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.ListDataSourcesResponse
      .builder()
      .optionallyWith(
        summaryItems.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.summaryItems)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.ListDataSourcesResponse.ReadOnly =
    zio.aws.kendra.model.ListDataSourcesResponse.wrap(buildAwsValue())
}
object ListDataSourcesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.ListDataSourcesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.ListDataSourcesResponse =
      zio.aws.kendra.model.ListDataSourcesResponse(
        summaryItems.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def summaryItems
        : Option[List[zio.aws.kendra.model.DataSourceSummary.ReadOnly]]
    def nextToken: Option[NextToken]
    def getSummaryItems: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.DataSourceSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("summaryItems", summaryItems)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.ListDataSourcesResponse
  ) extends zio.aws.kendra.model.ListDataSourcesResponse.ReadOnly {
    override val summaryItems
        : Option[List[zio.aws.kendra.model.DataSourceSummary.ReadOnly]] = scala
      .Option(impl.summaryItems())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.DataSourceSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.kendra.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.ListDataSourcesResponse
  ): zio.aws.kendra.model.ListDataSourcesResponse.ReadOnly = new Wrapper(impl)
}
