package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListEntityPersonasResponse(
    summaryItems: Option[Iterable[zio.aws.kendra.model.PersonasSummary]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.ListEntityPersonasResponse = {
    import ListEntityPersonasResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.ListEntityPersonasResponse
      .builder()
      .optionallyWith(
        summaryItems.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.summaryItems)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.ListEntityPersonasResponse.ReadOnly =
    zio.aws.kendra.model.ListEntityPersonasResponse.wrap(buildAwsValue())
}
object ListEntityPersonasResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.ListEntityPersonasResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.ListEntityPersonasResponse =
      zio.aws.kendra.model.ListEntityPersonasResponse(
        summaryItems.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def summaryItems
        : Option[List[zio.aws.kendra.model.PersonasSummary.ReadOnly]]
    def nextToken: Option[NextToken]
    def getSummaryItems: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.PersonasSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("summaryItems", summaryItems)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.ListEntityPersonasResponse
  ) extends zio.aws.kendra.model.ListEntityPersonasResponse.ReadOnly {
    override val summaryItems
        : Option[List[zio.aws.kendra.model.PersonasSummary.ReadOnly]] = scala
      .Option(impl.summaryItems())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.PersonasSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.kendra.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.ListEntityPersonasResponse
  ): zio.aws.kendra.model.ListEntityPersonasResponse.ReadOnly = new Wrapper(
    impl
  )
}
