package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListExperienceEntitiesResponse(
    summaryItems: Option[
      Iterable[zio.aws.kendra.model.ExperienceEntitiesSummary]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.ListExperienceEntitiesResponse = {
    import ListExperienceEntitiesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.ListExperienceEntitiesResponse
      .builder()
      .optionallyWith(
        summaryItems.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.summaryItems)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.ListExperienceEntitiesResponse.ReadOnly =
    zio.aws.kendra.model.ListExperienceEntitiesResponse.wrap(buildAwsValue())
}
object ListExperienceEntitiesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.ListExperienceEntitiesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.ListExperienceEntitiesResponse =
      zio.aws.kendra.model.ListExperienceEntitiesResponse(
        summaryItems.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def summaryItems
        : Option[List[zio.aws.kendra.model.ExperienceEntitiesSummary.ReadOnly]]
    def nextToken: Option[NextToken]
    def getSummaryItems: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.ExperienceEntitiesSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("summaryItems", summaryItems)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.ListExperienceEntitiesResponse
  ) extends zio.aws.kendra.model.ListExperienceEntitiesResponse.ReadOnly {
    override val summaryItems: Option[
      List[zio.aws.kendra.model.ExperienceEntitiesSummary.ReadOnly]
    ] = scala
      .Option(impl.summaryItems())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.ExperienceEntitiesSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.kendra.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.ListExperienceEntitiesResponse
  ): zio.aws.kendra.model.ListExperienceEntitiesResponse.ReadOnly = new Wrapper(
    impl
  )
}
