package zio.aws.kendra.model
import java.lang.Integer
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  MaxResultsIntegerForListExperiencesRequest,
  NextToken,
  IndexId
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListExperiencesRequest(
    indexId: IndexId,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResultsIntegerForListExperiencesRequest] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.ListExperiencesRequest = {
    import ListExperiencesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.ListExperiencesRequest
      .builder()
      .indexId(IndexId.unwrap(indexId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value =>
          MaxResultsIntegerForListExperiencesRequest.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.ListExperiencesRequest.ReadOnly =
    zio.aws.kendra.model.ListExperiencesRequest.wrap(buildAwsValue())
}
object ListExperiencesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.ListExperiencesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.ListExperiencesRequest =
      zio.aws.kendra.model.ListExperiencesRequest(
        indexId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def indexId: IndexId
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResultsIntegerForListExperiencesRequest]
    def getIndexId: ZIO[Any, Nothing, IndexId] = ZIO.succeed(indexId)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults
        : ZIO[Any, AwsError, MaxResultsIntegerForListExperiencesRequest] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.ListExperiencesRequest
  ) extends zio.aws.kendra.model.ListExperiencesRequest.ReadOnly {
    override val indexId: IndexId =
      zio.aws.kendra.model.primitives.IndexId(impl.indexId())
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.kendra.model.primitives.NextToken(value))
    override val maxResults
        : Option[MaxResultsIntegerForListExperiencesRequest] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.kendra.model.primitives
          .MaxResultsIntegerForListExperiencesRequest(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.ListExperiencesRequest
  ): zio.aws.kendra.model.ListExperiencesRequest.ReadOnly = new Wrapper(impl)
}
