package zio.aws.kendra.model
import java.lang.Integer
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  MaxResultsIntegerForListFaqsRequest,
  NextToken,
  IndexId
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListFaqsRequest(
    indexId: IndexId,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResultsIntegerForListFaqsRequest] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.ListFaqsRequest = {
    import ListFaqsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.ListFaqsRequest
      .builder()
      .indexId(IndexId.unwrap(indexId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value =>
          MaxResultsIntegerForListFaqsRequest.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.ListFaqsRequest.ReadOnly =
    zio.aws.kendra.model.ListFaqsRequest.wrap(buildAwsValue())
}
object ListFaqsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.ListFaqsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.ListFaqsRequest =
      zio.aws.kendra.model.ListFaqsRequest(
        indexId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def indexId: IndexId
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResultsIntegerForListFaqsRequest]
    def getIndexId: ZIO[Any, Nothing, IndexId] = ZIO.succeed(indexId)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResultsIntegerForListFaqsRequest] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.ListFaqsRequest
  ) extends zio.aws.kendra.model.ListFaqsRequest.ReadOnly {
    override val indexId: IndexId =
      zio.aws.kendra.model.primitives.IndexId(impl.indexId())
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.kendra.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResultsIntegerForListFaqsRequest] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.kendra.model.primitives
          .MaxResultsIntegerForListFaqsRequest(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.ListFaqsRequest
  ): zio.aws.kendra.model.ListFaqsRequest.ReadOnly = new Wrapper(impl)
}
