package zio.aws.kendra.model
import java.lang.Integer
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  MaxResultsIntegerForListIndicesRequest,
  NextToken
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListIndicesRequest(
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResultsIntegerForListIndicesRequest] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.ListIndicesRequest = {
    import ListIndicesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.ListIndicesRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value =>
          MaxResultsIntegerForListIndicesRequest.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.ListIndicesRequest.ReadOnly =
    zio.aws.kendra.model.ListIndicesRequest.wrap(buildAwsValue())
}
object ListIndicesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.ListIndicesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.ListIndicesRequest =
      zio.aws.kendra.model.ListIndicesRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResultsIntegerForListIndicesRequest]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults
        : ZIO[Any, AwsError, MaxResultsIntegerForListIndicesRequest] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.ListIndicesRequest
  ) extends zio.aws.kendra.model.ListIndicesRequest.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.kendra.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResultsIntegerForListIndicesRequest] =
      scala
        .Option(impl.maxResults())
        .map(value =>
          zio.aws.kendra.model.primitives
            .MaxResultsIntegerForListIndicesRequest(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.ListIndicesRequest
  ): zio.aws.kendra.model.ListIndicesRequest.ReadOnly = new Wrapper(impl)
}
