package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListQuerySuggestionsBlockListsResponse(
    blockListSummaryItems: Option[
      Iterable[zio.aws.kendra.model.QuerySuggestionsBlockListSummary]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.ListQuerySuggestionsBlockListsResponse = {
    import ListQuerySuggestionsBlockListsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.ListQuerySuggestionsBlockListsResponse
      .builder()
      .optionallyWith(
        blockListSummaryItems.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.blockListSummaryItems)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.ListQuerySuggestionsBlockListsResponse.ReadOnly =
    zio.aws.kendra.model.ListQuerySuggestionsBlockListsResponse
      .wrap(buildAwsValue())
}
object ListQuerySuggestionsBlockListsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.ListQuerySuggestionsBlockListsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kendra.model.ListQuerySuggestionsBlockListsResponse =
      zio.aws.kendra.model.ListQuerySuggestionsBlockListsResponse(
        blockListSummaryItems.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def blockListSummaryItems: Option[
      List[zio.aws.kendra.model.QuerySuggestionsBlockListSummary.ReadOnly]
    ]
    def nextToken: Option[NextToken]
    def getBlockListSummaryItems: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.QuerySuggestionsBlockListSummary.ReadOnly
    ]] =
      AwsError.unwrapOptionField("blockListSummaryItems", blockListSummaryItems)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.ListQuerySuggestionsBlockListsResponse
  ) extends zio.aws.kendra.model.ListQuerySuggestionsBlockListsResponse.ReadOnly {
    override val blockListSummaryItems: Option[
      List[zio.aws.kendra.model.QuerySuggestionsBlockListSummary.ReadOnly]
    ] = scala
      .Option(impl.blockListSummaryItems())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.QuerySuggestionsBlockListSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.kendra.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.ListQuerySuggestionsBlockListsResponse
  ): zio.aws.kendra.model.ListQuerySuggestionsBlockListsResponse.ReadOnly =
    new Wrapper(impl)
}
