package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.AmazonResourceName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceRequest(resourceARN: AmazonResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.ListTagsForResourceRequest
      .builder()
      .resourceARN(AmazonResourceName.unwrap(resourceARN): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.kendra.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.ListTagsForResourceRequest =
      zio.aws.kendra.model.ListTagsForResourceRequest(resourceARN)
    def resourceARN: AmazonResourceName
    def getResourceARN: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(resourceARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.ListTagsForResourceRequest
  ) extends zio.aws.kendra.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceARN: AmazonResourceName =
      zio.aws.kendra.model.primitives.AmazonResourceName(impl.resourceARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.ListTagsForResourceRequest
  ): zio.aws.kendra.model.ListTagsForResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
