package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListThesauriResponse(
    nextToken: Option[NextToken] = None,
    thesaurusSummaryItems: Option[
      Iterable[zio.aws.kendra.model.ThesaurusSummary]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.ListThesauriResponse = {
    import ListThesauriResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.ListThesauriResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        thesaurusSummaryItems.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.thesaurusSummaryItems)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.ListThesauriResponse.ReadOnly =
    zio.aws.kendra.model.ListThesauriResponse.wrap(buildAwsValue())
}
object ListThesauriResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.ListThesauriResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.ListThesauriResponse =
      zio.aws.kendra.model.ListThesauriResponse(
        nextToken.map(value => value),
        thesaurusSummaryItems.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[NextToken]
    def thesaurusSummaryItems
        : Option[List[zio.aws.kendra.model.ThesaurusSummary.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getThesaurusSummaryItems: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.ThesaurusSummary.ReadOnly
    ]] =
      AwsError.unwrapOptionField("thesaurusSummaryItems", thesaurusSummaryItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.ListThesauriResponse
  ) extends zio.aws.kendra.model.ListThesauriResponse.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.kendra.model.primitives.NextToken(value))
    override val thesaurusSummaryItems
        : Option[List[zio.aws.kendra.model.ThesaurusSummary.ReadOnly]] = scala
      .Option(impl.thesaurusSummaryItems())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.ThesaurusSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.ListThesauriResponse
  ): zio.aws.kendra.model.ListThesauriResponse.ReadOnly = new Wrapper(impl)
}
