package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  DataSourceInclusionsExclusionsStringsMember,
  SecretArn,
  TenantDomain
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class OneDriveConfiguration(
    tenantDomain: TenantDomain,
    secretArn: SecretArn,
    oneDriveUsers: zio.aws.kendra.model.OneDriveUsers,
    inclusionPatterns: Option[
      Iterable[DataSourceInclusionsExclusionsStringsMember]
    ] = None,
    exclusionPatterns: Option[
      Iterable[DataSourceInclusionsExclusionsStringsMember]
    ] = None,
    fieldMappings: Option[
      Iterable[zio.aws.kendra.model.DataSourceToIndexFieldMapping]
    ] = None,
    disableLocalGroups: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.OneDriveConfiguration = {
    import OneDriveConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.OneDriveConfiguration
      .builder()
      .tenantDomain(TenantDomain.unwrap(tenantDomain): java.lang.String)
      .secretArn(SecretArn.unwrap(secretArn): java.lang.String)
      .oneDriveUsers(oneDriveUsers.buildAwsValue())
      .optionallyWith(
        inclusionPatterns.map(value =>
          value.map { item =>
            DataSourceInclusionsExclusionsStringsMember.unwrap(
              item
            ): java.lang.String
          }.asJavaCollection
        )
      )(_.inclusionPatterns)
      .optionallyWith(
        exclusionPatterns.map(value =>
          value.map { item =>
            DataSourceInclusionsExclusionsStringsMember.unwrap(
              item
            ): java.lang.String
          }.asJavaCollection
        )
      )(_.exclusionPatterns)
      .optionallyWith(
        fieldMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fieldMappings)
      .optionallyWith(
        disableLocalGroups.map(value => value: java.lang.Boolean)
      )(_.disableLocalGroups)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.OneDriveConfiguration.ReadOnly =
    zio.aws.kendra.model.OneDriveConfiguration.wrap(buildAwsValue())
}
object OneDriveConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.OneDriveConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.OneDriveConfiguration =
      zio.aws.kendra.model.OneDriveConfiguration(
        tenantDomain,
        secretArn,
        oneDriveUsers.asEditable,
        inclusionPatterns.map(value => value),
        exclusionPatterns.map(value => value),
        fieldMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        disableLocalGroups.map(value => value)
      )
    def tenantDomain: TenantDomain
    def secretArn: SecretArn
    def oneDriveUsers: zio.aws.kendra.model.OneDriveUsers.ReadOnly
    def inclusionPatterns
        : Option[List[DataSourceInclusionsExclusionsStringsMember]]
    def exclusionPatterns
        : Option[List[DataSourceInclusionsExclusionsStringsMember]]
    def fieldMappings: Option[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ]
    def disableLocalGroups: Option[Boolean]
    def getTenantDomain: ZIO[Any, Nothing, TenantDomain] =
      ZIO.succeed(tenantDomain)
    def getSecretArn: ZIO[Any, Nothing, SecretArn] = ZIO.succeed(secretArn)
    def getOneDriveUsers
        : ZIO[Any, Nothing, zio.aws.kendra.model.OneDriveUsers.ReadOnly] =
      ZIO.succeed(oneDriveUsers)
    def getInclusionPatterns: ZIO[Any, AwsError, List[
      DataSourceInclusionsExclusionsStringsMember
    ]] = AwsError.unwrapOptionField("inclusionPatterns", inclusionPatterns)
    def getExclusionPatterns: ZIO[Any, AwsError, List[
      DataSourceInclusionsExclusionsStringsMember
    ]] = AwsError.unwrapOptionField("exclusionPatterns", exclusionPatterns)
    def getFieldMappings: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly
    ]] = AwsError.unwrapOptionField("fieldMappings", fieldMappings)
    def getDisableLocalGroups: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("disableLocalGroups", disableLocalGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.OneDriveConfiguration
  ) extends zio.aws.kendra.model.OneDriveConfiguration.ReadOnly {
    override val tenantDomain: TenantDomain =
      zio.aws.kendra.model.primitives.TenantDomain(impl.tenantDomain())
    override val secretArn: SecretArn =
      zio.aws.kendra.model.primitives.SecretArn(impl.secretArn())
    override val oneDriveUsers: zio.aws.kendra.model.OneDriveUsers.ReadOnly =
      zio.aws.kendra.model.OneDriveUsers.wrap(impl.oneDriveUsers())
    override val inclusionPatterns
        : Option[List[DataSourceInclusionsExclusionsStringsMember]] = scala
      .Option(impl.inclusionPatterns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.primitives
            .DataSourceInclusionsExclusionsStringsMember(item)
        }.toList
      )
    override val exclusionPatterns
        : Option[List[DataSourceInclusionsExclusionsStringsMember]] = scala
      .Option(impl.exclusionPatterns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.primitives
            .DataSourceInclusionsExclusionsStringsMember(item)
        }.toList
      )
    override val fieldMappings: Option[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ] = scala
      .Option(impl.fieldMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.DataSourceToIndexFieldMapping.wrap(item)
        }.toList
      )
    override val disableLocalGroups: Option[Boolean] =
      scala.Option(impl.disableLocalGroups()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.OneDriveConfiguration
  ): zio.aws.kendra.model.OneDriveConfiguration.ReadOnly = new Wrapper(impl)
}
