package zio.aws.kendra.model
import scala.jdk.CollectionConverters._
sealed trait PrincipalType {
  def unwrap: software.amazon.awssdk.services.kendra.model.PrincipalType
}
object PrincipalType {
  def wrap(
      value: software.amazon.awssdk.services.kendra.model.PrincipalType
  ): zio.aws.kendra.model.PrincipalType = value match {
    case software.amazon.awssdk.services.kendra.model.PrincipalType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kendra.model.PrincipalType.USER =>
      val r = USER
      r
    case software.amazon.awssdk.services.kendra.model.PrincipalType.GROUP =>
      val r = GROUP
      r
  }
  case object unknownToSdkVersion extends zio.aws.kendra.model.PrincipalType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.PrincipalType =
      software.amazon.awssdk.services.kendra.model.PrincipalType.UNKNOWN_TO_SDK_VERSION
  }
  case object USER extends zio.aws.kendra.model.PrincipalType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.PrincipalType =
      software.amazon.awssdk.services.kendra.model.PrincipalType.USER
  }
  case object GROUP extends zio.aws.kendra.model.PrincipalType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.PrincipalType =
      software.amazon.awssdk.services.kendra.model.PrincipalType.GROUP
  }
}
