package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{Integer, QueryId}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class QueryResponse(
    queryId: Option[QueryId] = None,
    resultItems: Option[Iterable[zio.aws.kendra.model.QueryResultItem]] = None,
    facetResults: Option[Iterable[zio.aws.kendra.model.FacetResult]] = None,
    totalNumberOfResults: Option[Integer] = None,
    warnings: Option[Iterable[zio.aws.kendra.model.Warning]] = None,
    spellCorrectedQueries: Option[
      Iterable[zio.aws.kendra.model.SpellCorrectedQuery]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.QueryResponse = {
    import QueryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.QueryResponse
      .builder()
      .optionallyWith(
        queryId.map(value => QueryId.unwrap(value): java.lang.String)
      )(_.queryId)
      .optionallyWith(
        resultItems.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resultItems)
      .optionallyWith(
        facetResults.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.facetResults)
      .optionallyWith(
        totalNumberOfResults.map(value => value: java.lang.Integer)
      )(_.totalNumberOfResults)
      .optionallyWith(
        warnings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.warnings)
      .optionallyWith(
        spellCorrectedQueries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.spellCorrectedQueries)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.QueryResponse.ReadOnly =
    zio.aws.kendra.model.QueryResponse.wrap(buildAwsValue())
}
object QueryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.QueryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.QueryResponse =
      zio.aws.kendra.model.QueryResponse(
        queryId.map(value => value),
        resultItems.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        facetResults.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        totalNumberOfResults.map(value => value),
        warnings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        spellCorrectedQueries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def queryId: Option[QueryId]
    def resultItems: Option[List[zio.aws.kendra.model.QueryResultItem.ReadOnly]]
    def facetResults: Option[List[zio.aws.kendra.model.FacetResult.ReadOnly]]
    def totalNumberOfResults: Option[Integer]
    def warnings: Option[List[zio.aws.kendra.model.Warning.ReadOnly]]
    def spellCorrectedQueries
        : Option[List[zio.aws.kendra.model.SpellCorrectedQuery.ReadOnly]]
    def getQueryId: ZIO[Any, AwsError, QueryId] =
      AwsError.unwrapOptionField("queryId", queryId)
    def getResultItems: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.QueryResultItem.ReadOnly
    ]] = AwsError.unwrapOptionField("resultItems", resultItems)
    def getFacetResults
        : ZIO[Any, AwsError, List[zio.aws.kendra.model.FacetResult.ReadOnly]] =
      AwsError.unwrapOptionField("facetResults", facetResults)
    def getTotalNumberOfResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("totalNumberOfResults", totalNumberOfResults)
    def getWarnings
        : ZIO[Any, AwsError, List[zio.aws.kendra.model.Warning.ReadOnly]] =
      AwsError.unwrapOptionField("warnings", warnings)
    def getSpellCorrectedQueries: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.SpellCorrectedQuery.ReadOnly
    ]] =
      AwsError.unwrapOptionField("spellCorrectedQueries", spellCorrectedQueries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.QueryResponse
  ) extends zio.aws.kendra.model.QueryResponse.ReadOnly {
    override val queryId: Option[QueryId] = scala
      .Option(impl.queryId())
      .map(value => zio.aws.kendra.model.primitives.QueryId(value))
    override val resultItems
        : Option[List[zio.aws.kendra.model.QueryResultItem.ReadOnly]] = scala
      .Option(impl.resultItems())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.QueryResultItem.wrap(item)
        }.toList
      )
    override val facetResults
        : Option[List[zio.aws.kendra.model.FacetResult.ReadOnly]] = scala
      .Option(impl.facetResults())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.FacetResult.wrap(item)
        }.toList
      )
    override val totalNumberOfResults: Option[Integer] =
      scala.Option(impl.totalNumberOfResults()).map(value => value: Integer)
    override val warnings: Option[List[zio.aws.kendra.model.Warning.ReadOnly]] =
      scala
        .Option(impl.warnings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.Warning.wrap(item)
          }.toList
        )
    override val spellCorrectedQueries
        : Option[List[zio.aws.kendra.model.SpellCorrectedQuery.ReadOnly]] =
      scala
        .Option(impl.spellCorrectedQueries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.SpellCorrectedQuery.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.QueryResponse
  ): zio.aws.kendra.model.QueryResponse.ReadOnly = new Wrapper(impl)
}
