package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  FeedbackToken,
  Url,
  DocumentId,
  ResultId
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class QueryResultItem(
    id: Option[ResultId] = None,
    `type`: Option[zio.aws.kendra.model.QueryResultType] = None,
    additionalAttributes: Option[
      Iterable[zio.aws.kendra.model.AdditionalResultAttribute]
    ] = None,
    documentId: Option[DocumentId] = None,
    documentTitle: Option[zio.aws.kendra.model.TextWithHighlights] = None,
    documentExcerpt: Option[zio.aws.kendra.model.TextWithHighlights] = None,
    documentURI: Option[Url] = None,
    documentAttributes: Option[
      Iterable[zio.aws.kendra.model.DocumentAttribute]
    ] = None,
    scoreAttributes: Option[zio.aws.kendra.model.ScoreAttributes] = None,
    feedbackToken: Option[FeedbackToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.QueryResultItem = {
    import QueryResultItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.QueryResultItem
      .builder()
      .optionallyWith(
        id.map(value => ResultId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        additionalAttributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.additionalAttributes)
      .optionallyWith(
        documentId.map(value => DocumentId.unwrap(value): java.lang.String)
      )(_.documentId)
      .optionallyWith(documentTitle.map(value => value.buildAwsValue()))(
        _.documentTitle
      )
      .optionallyWith(documentExcerpt.map(value => value.buildAwsValue()))(
        _.documentExcerpt
      )
      .optionallyWith(
        documentURI.map(value => Url.unwrap(value): java.lang.String)
      )(_.documentURI)
      .optionallyWith(
        documentAttributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.documentAttributes)
      .optionallyWith(scoreAttributes.map(value => value.buildAwsValue()))(
        _.scoreAttributes
      )
      .optionallyWith(
        feedbackToken.map(value =>
          FeedbackToken.unwrap(value): java.lang.String
        )
      )(_.feedbackToken)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.QueryResultItem.ReadOnly =
    zio.aws.kendra.model.QueryResultItem.wrap(buildAwsValue())
}
object QueryResultItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.QueryResultItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.QueryResultItem =
      zio.aws.kendra.model.QueryResultItem(
        id.map(value => value),
        `type`.map(value => value),
        additionalAttributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        documentId.map(value => value),
        documentTitle.map(value => value.asEditable),
        documentExcerpt.map(value => value.asEditable),
        documentURI.map(value => value),
        documentAttributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        scoreAttributes.map(value => value.asEditable),
        feedbackToken.map(value => value)
      )
    def id: Option[ResultId]
    def `type`: Option[zio.aws.kendra.model.QueryResultType]
    def additionalAttributes
        : Option[List[zio.aws.kendra.model.AdditionalResultAttribute.ReadOnly]]
    def documentId: Option[DocumentId]
    def documentTitle: Option[zio.aws.kendra.model.TextWithHighlights.ReadOnly]
    def documentExcerpt
        : Option[zio.aws.kendra.model.TextWithHighlights.ReadOnly]
    def documentURI: Option[Url]
    def documentAttributes
        : Option[List[zio.aws.kendra.model.DocumentAttribute.ReadOnly]]
    def scoreAttributes: Option[zio.aws.kendra.model.ScoreAttributes.ReadOnly]
    def feedbackToken: Option[FeedbackToken]
    def getId: ZIO[Any, AwsError, ResultId] =
      AwsError.unwrapOptionField("id", id)
    def getType: ZIO[Any, AwsError, zio.aws.kendra.model.QueryResultType] =
      AwsError.unwrapOptionField("type", `type`)
    def getAdditionalAttributes: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.AdditionalResultAttribute.ReadOnly
    ]] =
      AwsError.unwrapOptionField("additionalAttributes", additionalAttributes)
    def getDocumentId: ZIO[Any, AwsError, DocumentId] =
      AwsError.unwrapOptionField("documentId", documentId)
    def getDocumentTitle
        : ZIO[Any, AwsError, zio.aws.kendra.model.TextWithHighlights.ReadOnly] =
      AwsError.unwrapOptionField("documentTitle", documentTitle)
    def getDocumentExcerpt
        : ZIO[Any, AwsError, zio.aws.kendra.model.TextWithHighlights.ReadOnly] =
      AwsError.unwrapOptionField("documentExcerpt", documentExcerpt)
    def getDocumentURI: ZIO[Any, AwsError, Url] =
      AwsError.unwrapOptionField("documentURI", documentURI)
    def getDocumentAttributes: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.DocumentAttribute.ReadOnly
    ]] = AwsError.unwrapOptionField("documentAttributes", documentAttributes)
    def getScoreAttributes
        : ZIO[Any, AwsError, zio.aws.kendra.model.ScoreAttributes.ReadOnly] =
      AwsError.unwrapOptionField("scoreAttributes", scoreAttributes)
    def getFeedbackToken: ZIO[Any, AwsError, FeedbackToken] =
      AwsError.unwrapOptionField("feedbackToken", feedbackToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.QueryResultItem
  ) extends zio.aws.kendra.model.QueryResultItem.ReadOnly {
    override val id: Option[ResultId] = scala
      .Option(impl.id())
      .map(value => zio.aws.kendra.model.primitives.ResultId(value))
    override val `type`: Option[zio.aws.kendra.model.QueryResultType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.kendra.model.QueryResultType.wrap(value))
    override val additionalAttributes: Option[
      List[zio.aws.kendra.model.AdditionalResultAttribute.ReadOnly]
    ] = scala
      .Option(impl.additionalAttributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.AdditionalResultAttribute.wrap(item)
        }.toList
      )
    override val documentId: Option[DocumentId] = scala
      .Option(impl.documentId())
      .map(value => zio.aws.kendra.model.primitives.DocumentId(value))
    override val documentTitle
        : Option[zio.aws.kendra.model.TextWithHighlights.ReadOnly] = scala
      .Option(impl.documentTitle())
      .map(value => zio.aws.kendra.model.TextWithHighlights.wrap(value))
    override val documentExcerpt
        : Option[zio.aws.kendra.model.TextWithHighlights.ReadOnly] = scala
      .Option(impl.documentExcerpt())
      .map(value => zio.aws.kendra.model.TextWithHighlights.wrap(value))
    override val documentURI: Option[Url] = scala
      .Option(impl.documentURI())
      .map(value => zio.aws.kendra.model.primitives.Url(value))
    override val documentAttributes
        : Option[List[zio.aws.kendra.model.DocumentAttribute.ReadOnly]] = scala
      .Option(impl.documentAttributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.DocumentAttribute.wrap(item)
        }.toList
      )
    override val scoreAttributes
        : Option[zio.aws.kendra.model.ScoreAttributes.ReadOnly] = scala
      .Option(impl.scoreAttributes())
      .map(value => zio.aws.kendra.model.ScoreAttributes.wrap(value))
    override val feedbackToken: Option[FeedbackToken] = scala
      .Option(impl.feedbackToken())
      .map(value => zio.aws.kendra.model.primitives.FeedbackToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.QueryResultItem
  ): zio.aws.kendra.model.QueryResultItem.ReadOnly = new Wrapper(impl)
}
