package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  Integer,
  Timestamp,
  QuerySuggestionsBlockListName,
  QuerySuggestionsBlockListId
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class QuerySuggestionsBlockListSummary(
    id: Option[QuerySuggestionsBlockListId] = None,
    name: Option[QuerySuggestionsBlockListName] = None,
    status: Option[zio.aws.kendra.model.QuerySuggestionsBlockListStatus] = None,
    createdAt: Option[Timestamp] = None,
    updatedAt: Option[Timestamp] = None,
    itemCount: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.QuerySuggestionsBlockListSummary = {
    import QuerySuggestionsBlockListSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.QuerySuggestionsBlockListSummary
      .builder()
      .optionallyWith(
        id.map(value =>
          QuerySuggestionsBlockListId.unwrap(value): java.lang.String
        )
      )(_.id)
      .optionallyWith(
        name.map(value =>
          QuerySuggestionsBlockListName.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .optionallyWith(itemCount.map(value => value: java.lang.Integer))(
        _.itemCount
      )
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.QuerySuggestionsBlockListSummary.ReadOnly =
    zio.aws.kendra.model.QuerySuggestionsBlockListSummary.wrap(buildAwsValue())
}
object QuerySuggestionsBlockListSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.QuerySuggestionsBlockListSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.QuerySuggestionsBlockListSummary =
      zio.aws.kendra.model.QuerySuggestionsBlockListSummary(
        id.map(value => value),
        name.map(value => value),
        status.map(value => value),
        createdAt.map(value => value),
        updatedAt.map(value => value),
        itemCount.map(value => value)
      )
    def id: Option[QuerySuggestionsBlockListId]
    def name: Option[QuerySuggestionsBlockListName]
    def status: Option[zio.aws.kendra.model.QuerySuggestionsBlockListStatus]
    def createdAt: Option[Timestamp]
    def updatedAt: Option[Timestamp]
    def itemCount: Option[Integer]
    def getId: ZIO[Any, AwsError, QuerySuggestionsBlockListId] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, QuerySuggestionsBlockListName] =
      AwsError.unwrapOptionField("name", name)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.QuerySuggestionsBlockListStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getItemCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("itemCount", itemCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.QuerySuggestionsBlockListSummary
  ) extends zio.aws.kendra.model.QuerySuggestionsBlockListSummary.ReadOnly {
    override val id: Option[QuerySuggestionsBlockListId] = scala
      .Option(impl.id())
      .map(value =>
        zio.aws.kendra.model.primitives.QuerySuggestionsBlockListId(value)
      )
    override val name: Option[QuerySuggestionsBlockListName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.kendra.model.primitives.QuerySuggestionsBlockListName(value)
      )
    override val status
        : Option[zio.aws.kendra.model.QuerySuggestionsBlockListStatus] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.kendra.model.QuerySuggestionsBlockListStatus.wrap(value)
      )
    override val createdAt: Option[Timestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.kendra.model.primitives.Timestamp(value))
    override val updatedAt: Option[Timestamp] = scala
      .Option(impl.updatedAt())
      .map(value => zio.aws.kendra.model.primitives.Timestamp(value))
    override val itemCount: Option[Integer] =
      scala.Option(impl.itemCount()).map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.QuerySuggestionsBlockListSummary
  ): zio.aws.kendra.model.QuerySuggestionsBlockListSummary.ReadOnly =
    new Wrapper(impl)
}
