package zio.aws.kendra.model
import java.lang.Integer
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  ValueImportanceMapKey,
  Duration,
  Importance,
  DocumentMetadataBoolean
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Relevance(
    freshness: Option[DocumentMetadataBoolean] = None,
    importance: Option[Importance] = None,
    duration: Option[Duration] = None,
    rankOrder: Option[zio.aws.kendra.model.Order] = None,
    valueImportanceMap: Option[Map[ValueImportanceMapKey, Importance]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.Relevance = {
    import Relevance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.Relevance
      .builder()
      .optionallyWith(
        freshness.map(value =>
          DocumentMetadataBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.freshness)
      .optionallyWith(
        importance.map(value => Importance.unwrap(value): Integer)
      )(_.importance)
      .optionallyWith(
        duration.map(value => Duration.unwrap(value): java.lang.String)
      )(_.duration)
      .optionallyWith(rankOrder.map(value => value.unwrap))(_.rankOrder)
      .optionallyWith(
        valueImportanceMap.map(value =>
          value
            .map({ case (key, value) =>
              (ValueImportanceMapKey.unwrap(
                key
              ): java.lang.String) -> (Importance.unwrap(value): Integer)
            })
            .asJava
        )
      )(_.valueImportanceMap)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.Relevance.ReadOnly =
    zio.aws.kendra.model.Relevance.wrap(buildAwsValue())
}
object Relevance {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kendra.model.Relevance] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.Relevance =
      zio.aws.kendra.model.Relevance(
        freshness.map(value => value),
        importance.map(value => value),
        duration.map(value => value),
        rankOrder.map(value => value),
        valueImportanceMap.map(value => value)
      )
    def freshness: Option[DocumentMetadataBoolean]
    def importance: Option[Importance]
    def duration: Option[Duration]
    def rankOrder: Option[zio.aws.kendra.model.Order]
    def valueImportanceMap: Option[Map[ValueImportanceMapKey, Importance]]
    def getFreshness: ZIO[Any, AwsError, DocumentMetadataBoolean] =
      AwsError.unwrapOptionField("freshness", freshness)
    def getImportance: ZIO[Any, AwsError, Importance] =
      AwsError.unwrapOptionField("importance", importance)
    def getDuration: ZIO[Any, AwsError, Duration] =
      AwsError.unwrapOptionField("duration", duration)
    def getRankOrder: ZIO[Any, AwsError, zio.aws.kendra.model.Order] =
      AwsError.unwrapOptionField("rankOrder", rankOrder)
    def getValueImportanceMap
        : ZIO[Any, AwsError, Map[ValueImportanceMapKey, Importance]] =
      AwsError.unwrapOptionField("valueImportanceMap", valueImportanceMap)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.Relevance
  ) extends zio.aws.kendra.model.Relevance.ReadOnly {
    override val freshness: Option[DocumentMetadataBoolean] = scala
      .Option(impl.freshness())
      .map(value =>
        zio.aws.kendra.model.primitives.DocumentMetadataBoolean(value)
      )
    override val importance: Option[Importance] = scala
      .Option(impl.importance())
      .map(value => zio.aws.kendra.model.primitives.Importance(value))
    override val duration: Option[Duration] = scala
      .Option(impl.duration())
      .map(value => zio.aws.kendra.model.primitives.Duration(value))
    override val rankOrder: Option[zio.aws.kendra.model.Order] = scala
      .Option(impl.rankOrder())
      .map(value => zio.aws.kendra.model.Order.wrap(value))
    override val valueImportanceMap
        : Option[Map[ValueImportanceMapKey, Importance]] = scala
      .Option(impl.valueImportanceMap())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.kendra.model.primitives.ValueImportanceMapKey(
              key
            ) -> zio.aws.kendra.model.primitives.Importance(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.Relevance
  ): zio.aws.kendra.model.Relevance.ReadOnly = new Wrapper(impl)
}
