package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  DataSourceInclusionsExclusionsStringsMember,
  S3BucketName
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class S3DataSourceConfiguration(
    bucketName: S3BucketName,
    inclusionPrefixes: Option[
      Iterable[DataSourceInclusionsExclusionsStringsMember]
    ] = None,
    inclusionPatterns: Option[
      Iterable[DataSourceInclusionsExclusionsStringsMember]
    ] = None,
    exclusionPatterns: Option[
      Iterable[DataSourceInclusionsExclusionsStringsMember]
    ] = None,
    documentsMetadataConfiguration: Option[
      zio.aws.kendra.model.DocumentsMetadataConfiguration
    ] = None,
    accessControlListConfiguration: Option[
      zio.aws.kendra.model.AccessControlListConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.S3DataSourceConfiguration = {
    import S3DataSourceConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.S3DataSourceConfiguration
      .builder()
      .bucketName(S3BucketName.unwrap(bucketName): java.lang.String)
      .optionallyWith(
        inclusionPrefixes.map(value =>
          value.map { item =>
            DataSourceInclusionsExclusionsStringsMember.unwrap(
              item
            ): java.lang.String
          }.asJavaCollection
        )
      )(_.inclusionPrefixes)
      .optionallyWith(
        inclusionPatterns.map(value =>
          value.map { item =>
            DataSourceInclusionsExclusionsStringsMember.unwrap(
              item
            ): java.lang.String
          }.asJavaCollection
        )
      )(_.inclusionPatterns)
      .optionallyWith(
        exclusionPatterns.map(value =>
          value.map { item =>
            DataSourceInclusionsExclusionsStringsMember.unwrap(
              item
            ): java.lang.String
          }.asJavaCollection
        )
      )(_.exclusionPatterns)
      .optionallyWith(
        documentsMetadataConfiguration.map(value => value.buildAwsValue())
      )(_.documentsMetadataConfiguration)
      .optionallyWith(
        accessControlListConfiguration.map(value => value.buildAwsValue())
      )(_.accessControlListConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.S3DataSourceConfiguration.ReadOnly =
    zio.aws.kendra.model.S3DataSourceConfiguration.wrap(buildAwsValue())
}
object S3DataSourceConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.S3DataSourceConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.S3DataSourceConfiguration =
      zio.aws.kendra.model.S3DataSourceConfiguration(
        bucketName,
        inclusionPrefixes.map(value => value),
        inclusionPatterns.map(value => value),
        exclusionPatterns.map(value => value),
        documentsMetadataConfiguration.map(value => value.asEditable),
        accessControlListConfiguration.map(value => value.asEditable)
      )
    def bucketName: S3BucketName
    def inclusionPrefixes
        : Option[List[DataSourceInclusionsExclusionsStringsMember]]
    def inclusionPatterns
        : Option[List[DataSourceInclusionsExclusionsStringsMember]]
    def exclusionPatterns
        : Option[List[DataSourceInclusionsExclusionsStringsMember]]
    def documentsMetadataConfiguration
        : Option[zio.aws.kendra.model.DocumentsMetadataConfiguration.ReadOnly]
    def accessControlListConfiguration
        : Option[zio.aws.kendra.model.AccessControlListConfiguration.ReadOnly]
    def getBucketName: ZIO[Any, Nothing, S3BucketName] = ZIO.succeed(bucketName)
    def getInclusionPrefixes: ZIO[Any, AwsError, List[
      DataSourceInclusionsExclusionsStringsMember
    ]] = AwsError.unwrapOptionField("inclusionPrefixes", inclusionPrefixes)
    def getInclusionPatterns: ZIO[Any, AwsError, List[
      DataSourceInclusionsExclusionsStringsMember
    ]] = AwsError.unwrapOptionField("inclusionPatterns", inclusionPatterns)
    def getExclusionPatterns: ZIO[Any, AwsError, List[
      DataSourceInclusionsExclusionsStringsMember
    ]] = AwsError.unwrapOptionField("exclusionPatterns", exclusionPatterns)
    def getDocumentsMetadataConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.DocumentsMetadataConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "documentsMetadataConfiguration",
      documentsMetadataConfiguration
    )
    def getAccessControlListConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.AccessControlListConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "accessControlListConfiguration",
      accessControlListConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.S3DataSourceConfiguration
  ) extends zio.aws.kendra.model.S3DataSourceConfiguration.ReadOnly {
    override val bucketName: S3BucketName =
      zio.aws.kendra.model.primitives.S3BucketName(impl.bucketName())
    override val inclusionPrefixes
        : Option[List[DataSourceInclusionsExclusionsStringsMember]] = scala
      .Option(impl.inclusionPrefixes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.primitives
            .DataSourceInclusionsExclusionsStringsMember(item)
        }.toList
      )
    override val inclusionPatterns
        : Option[List[DataSourceInclusionsExclusionsStringsMember]] = scala
      .Option(impl.inclusionPatterns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.primitives
            .DataSourceInclusionsExclusionsStringsMember(item)
        }.toList
      )
    override val exclusionPatterns
        : Option[List[DataSourceInclusionsExclusionsStringsMember]] = scala
      .Option(impl.exclusionPatterns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.primitives
            .DataSourceInclusionsExclusionsStringsMember(item)
        }.toList
      )
    override val documentsMetadataConfiguration
        : Option[zio.aws.kendra.model.DocumentsMetadataConfiguration.ReadOnly] =
      scala
        .Option(impl.documentsMetadataConfiguration())
        .map(value =>
          zio.aws.kendra.model.DocumentsMetadataConfiguration.wrap(value)
        )
    override val accessControlListConfiguration
        : Option[zio.aws.kendra.model.AccessControlListConfiguration.ReadOnly] =
      scala
        .Option(impl.accessControlListConfiguration())
        .map(value =>
          zio.aws.kendra.model.AccessControlListConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.S3DataSourceConfiguration
  ): zio.aws.kendra.model.S3DataSourceConfiguration.ReadOnly = new Wrapper(impl)
}
