package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.DataSourceFieldName
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SalesforceChatterFeedConfiguration(
    documentDataFieldName: DataSourceFieldName,
    documentTitleFieldName: Option[DataSourceFieldName] = None,
    fieldMappings: Option[
      Iterable[zio.aws.kendra.model.DataSourceToIndexFieldMapping]
    ] = None,
    includeFilterTypes: Option[
      Iterable[zio.aws.kendra.model.SalesforceChatterFeedIncludeFilterType]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.SalesforceChatterFeedConfiguration = {
    import SalesforceChatterFeedConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.SalesforceChatterFeedConfiguration
      .builder()
      .documentDataFieldName(
        DataSourceFieldName.unwrap(documentDataFieldName): java.lang.String
      )
      .optionallyWith(
        documentTitleFieldName.map(value =>
          DataSourceFieldName.unwrap(value): java.lang.String
        )
      )(_.documentTitleFieldName)
      .optionallyWith(
        fieldMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fieldMappings)
      .optionallyWith(
        includeFilterTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.includeFilterTypesWithStrings)
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.SalesforceChatterFeedConfiguration.ReadOnly =
    zio.aws.kendra.model.SalesforceChatterFeedConfiguration
      .wrap(buildAwsValue())
}
object SalesforceChatterFeedConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.SalesforceChatterFeedConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.SalesforceChatterFeedConfiguration =
      zio.aws.kendra.model.SalesforceChatterFeedConfiguration(
        documentDataFieldName,
        documentTitleFieldName.map(value => value),
        fieldMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        includeFilterTypes.map(value => value)
      )
    def documentDataFieldName: DataSourceFieldName
    def documentTitleFieldName: Option[DataSourceFieldName]
    def fieldMappings: Option[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ]
    def includeFilterTypes: Option[
      List[zio.aws.kendra.model.SalesforceChatterFeedIncludeFilterType]
    ]
    def getDocumentDataFieldName: ZIO[Any, Nothing, DataSourceFieldName] =
      ZIO.succeed(documentDataFieldName)
    def getDocumentTitleFieldName: ZIO[Any, AwsError, DataSourceFieldName] =
      AwsError.unwrapOptionField(
        "documentTitleFieldName",
        documentTitleFieldName
      )
    def getFieldMappings: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly
    ]] = AwsError.unwrapOptionField("fieldMappings", fieldMappings)
    def getIncludeFilterTypes: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.SalesforceChatterFeedIncludeFilterType
    ]] = AwsError.unwrapOptionField("includeFilterTypes", includeFilterTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.SalesforceChatterFeedConfiguration
  ) extends zio.aws.kendra.model.SalesforceChatterFeedConfiguration.ReadOnly {
    override val documentDataFieldName: DataSourceFieldName =
      zio.aws.kendra.model.primitives
        .DataSourceFieldName(impl.documentDataFieldName())
    override val documentTitleFieldName: Option[DataSourceFieldName] = scala
      .Option(impl.documentTitleFieldName())
      .map(value => zio.aws.kendra.model.primitives.DataSourceFieldName(value))
    override val fieldMappings: Option[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ] = scala
      .Option(impl.fieldMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.DataSourceToIndexFieldMapping.wrap(item)
        }.toList
      )
    override val includeFilterTypes: Option[
      List[zio.aws.kendra.model.SalesforceChatterFeedIncludeFilterType]
    ] = scala
      .Option(impl.includeFilterTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.SalesforceChatterFeedIncludeFilterType.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.SalesforceChatterFeedConfiguration
  ): zio.aws.kendra.model.SalesforceChatterFeedConfiguration.ReadOnly =
    new Wrapper(impl)
}
