package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  DataSourceInclusionsExclusionsStringsMember,
  SecretArn,
  Url
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SalesforceConfiguration(
    serverUrl: Url,
    secretArn: SecretArn,
    standardObjectConfigurations: Option[
      Iterable[zio.aws.kendra.model.SalesforceStandardObjectConfiguration]
    ] = None,
    knowledgeArticleConfiguration: Option[
      zio.aws.kendra.model.SalesforceKnowledgeArticleConfiguration
    ] = None,
    chatterFeedConfiguration: Option[
      zio.aws.kendra.model.SalesforceChatterFeedConfiguration
    ] = None,
    crawlAttachments: Option[Boolean] = None,
    standardObjectAttachmentConfiguration: Option[
      zio.aws.kendra.model.SalesforceStandardObjectAttachmentConfiguration
    ] = None,
    includeAttachmentFilePatterns: Option[
      Iterable[DataSourceInclusionsExclusionsStringsMember]
    ] = None,
    excludeAttachmentFilePatterns: Option[
      Iterable[DataSourceInclusionsExclusionsStringsMember]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.SalesforceConfiguration = {
    import SalesforceConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.SalesforceConfiguration
      .builder()
      .serverUrl(Url.unwrap(serverUrl): java.lang.String)
      .secretArn(SecretArn.unwrap(secretArn): java.lang.String)
      .optionallyWith(
        standardObjectConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.standardObjectConfigurations)
      .optionallyWith(
        knowledgeArticleConfiguration.map(value => value.buildAwsValue())
      )(_.knowledgeArticleConfiguration)
      .optionallyWith(
        chatterFeedConfiguration.map(value => value.buildAwsValue())
      )(_.chatterFeedConfiguration)
      .optionallyWith(crawlAttachments.map(value => value: java.lang.Boolean))(
        _.crawlAttachments
      )
      .optionallyWith(
        standardObjectAttachmentConfiguration.map(value =>
          value.buildAwsValue()
        )
      )(_.standardObjectAttachmentConfiguration)
      .optionallyWith(
        includeAttachmentFilePatterns.map(value =>
          value.map { item =>
            DataSourceInclusionsExclusionsStringsMember.unwrap(
              item
            ): java.lang.String
          }.asJavaCollection
        )
      )(_.includeAttachmentFilePatterns)
      .optionallyWith(
        excludeAttachmentFilePatterns.map(value =>
          value.map { item =>
            DataSourceInclusionsExclusionsStringsMember.unwrap(
              item
            ): java.lang.String
          }.asJavaCollection
        )
      )(_.excludeAttachmentFilePatterns)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.SalesforceConfiguration.ReadOnly =
    zio.aws.kendra.model.SalesforceConfiguration.wrap(buildAwsValue())
}
object SalesforceConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.SalesforceConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.SalesforceConfiguration =
      zio.aws.kendra.model.SalesforceConfiguration(
        serverUrl,
        secretArn,
        standardObjectConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        knowledgeArticleConfiguration.map(value => value.asEditable),
        chatterFeedConfiguration.map(value => value.asEditable),
        crawlAttachments.map(value => value),
        standardObjectAttachmentConfiguration.map(value => value.asEditable),
        includeAttachmentFilePatterns.map(value => value),
        excludeAttachmentFilePatterns.map(value => value)
      )
    def serverUrl: Url
    def secretArn: SecretArn
    def standardObjectConfigurations: Option[
      List[zio.aws.kendra.model.SalesforceStandardObjectConfiguration.ReadOnly]
    ]
    def knowledgeArticleConfiguration: Option[
      zio.aws.kendra.model.SalesforceKnowledgeArticleConfiguration.ReadOnly
    ]
    def chatterFeedConfiguration: Option[
      zio.aws.kendra.model.SalesforceChatterFeedConfiguration.ReadOnly
    ]
    def crawlAttachments: Option[Boolean]
    def standardObjectAttachmentConfiguration: Option[
      zio.aws.kendra.model.SalesforceStandardObjectAttachmentConfiguration.ReadOnly
    ]
    def includeAttachmentFilePatterns
        : Option[List[DataSourceInclusionsExclusionsStringsMember]]
    def excludeAttachmentFilePatterns
        : Option[List[DataSourceInclusionsExclusionsStringsMember]]
    def getServerUrl: ZIO[Any, Nothing, Url] = ZIO.succeed(serverUrl)
    def getSecretArn: ZIO[Any, Nothing, SecretArn] = ZIO.succeed(secretArn)
    def getStandardObjectConfigurations: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.SalesforceStandardObjectConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "standardObjectConfigurations",
      standardObjectConfigurations
    )
    def getKnowledgeArticleConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.SalesforceKnowledgeArticleConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "knowledgeArticleConfiguration",
      knowledgeArticleConfiguration
    )
    def getChatterFeedConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.SalesforceChatterFeedConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "chatterFeedConfiguration",
      chatterFeedConfiguration
    )
    def getCrawlAttachments: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("crawlAttachments", crawlAttachments)
    def getStandardObjectAttachmentConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.SalesforceStandardObjectAttachmentConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "standardObjectAttachmentConfiguration",
      standardObjectAttachmentConfiguration
    )
    def getIncludeAttachmentFilePatterns: ZIO[Any, AwsError, List[
      DataSourceInclusionsExclusionsStringsMember
    ]] = AwsError.unwrapOptionField(
      "includeAttachmentFilePatterns",
      includeAttachmentFilePatterns
    )
    def getExcludeAttachmentFilePatterns: ZIO[Any, AwsError, List[
      DataSourceInclusionsExclusionsStringsMember
    ]] = AwsError.unwrapOptionField(
      "excludeAttachmentFilePatterns",
      excludeAttachmentFilePatterns
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.SalesforceConfiguration
  ) extends zio.aws.kendra.model.SalesforceConfiguration.ReadOnly {
    override val serverUrl: Url =
      zio.aws.kendra.model.primitives.Url(impl.serverUrl())
    override val secretArn: SecretArn =
      zio.aws.kendra.model.primitives.SecretArn(impl.secretArn())
    override val standardObjectConfigurations: Option[
      List[zio.aws.kendra.model.SalesforceStandardObjectConfiguration.ReadOnly]
    ] = scala
      .Option(impl.standardObjectConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.SalesforceStandardObjectConfiguration.wrap(item)
        }.toList
      )
    override val knowledgeArticleConfiguration: Option[
      zio.aws.kendra.model.SalesforceKnowledgeArticleConfiguration.ReadOnly
    ] = scala
      .Option(impl.knowledgeArticleConfiguration())
      .map(value =>
        zio.aws.kendra.model.SalesforceKnowledgeArticleConfiguration.wrap(value)
      )
    override val chatterFeedConfiguration: Option[
      zio.aws.kendra.model.SalesforceChatterFeedConfiguration.ReadOnly
    ] = scala
      .Option(impl.chatterFeedConfiguration())
      .map(value =>
        zio.aws.kendra.model.SalesforceChatterFeedConfiguration.wrap(value)
      )
    override val crawlAttachments: Option[Boolean] =
      scala.Option(impl.crawlAttachments()).map(value => value: Boolean)
    override val standardObjectAttachmentConfiguration: Option[
      zio.aws.kendra.model.SalesforceStandardObjectAttachmentConfiguration.ReadOnly
    ] = scala
      .Option(impl.standardObjectAttachmentConfiguration())
      .map(value =>
        zio.aws.kendra.model.SalesforceStandardObjectAttachmentConfiguration
          .wrap(value)
      )
    override val includeAttachmentFilePatterns
        : Option[List[DataSourceInclusionsExclusionsStringsMember]] = scala
      .Option(impl.includeAttachmentFilePatterns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.primitives
            .DataSourceInclusionsExclusionsStringsMember(item)
        }.toList
      )
    override val excludeAttachmentFilePatterns
        : Option[List[DataSourceInclusionsExclusionsStringsMember]] = scala
      .Option(impl.excludeAttachmentFilePatterns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.primitives
            .DataSourceInclusionsExclusionsStringsMember(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.SalesforceConfiguration
  ): zio.aws.kendra.model.SalesforceConfiguration.ReadOnly = new Wrapper(impl)
}
