package zio.aws.kendra.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SalesforceKnowledgeArticleConfiguration(
    includedStates: Iterable[
      zio.aws.kendra.model.SalesforceKnowledgeArticleState
    ],
    standardKnowledgeArticleTypeConfiguration: Option[
      zio.aws.kendra.model.SalesforceStandardKnowledgeArticleTypeConfiguration
    ] = None,
    customKnowledgeArticleTypeConfigurations: Option[Iterable[
      zio.aws.kendra.model.SalesforceCustomKnowledgeArticleTypeConfiguration
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.SalesforceKnowledgeArticleConfiguration = {
    import SalesforceKnowledgeArticleConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.SalesforceKnowledgeArticleConfiguration
      .builder()
      .includedStatesWithStrings(includedStates.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .optionallyWith(
        standardKnowledgeArticleTypeConfiguration.map(value =>
          value.buildAwsValue()
        )
      )(_.standardKnowledgeArticleTypeConfiguration)
      .optionallyWith(
        customKnowledgeArticleTypeConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.customKnowledgeArticleTypeConfigurations)
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.SalesforceKnowledgeArticleConfiguration.ReadOnly =
    zio.aws.kendra.model.SalesforceKnowledgeArticleConfiguration
      .wrap(buildAwsValue())
}
object SalesforceKnowledgeArticleConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.SalesforceKnowledgeArticleConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kendra.model.SalesforceKnowledgeArticleConfiguration =
      zio.aws.kendra.model.SalesforceKnowledgeArticleConfiguration(
        includedStates,
        standardKnowledgeArticleTypeConfiguration.map(value =>
          value.asEditable
        ),
        customKnowledgeArticleTypeConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def includedStates
        : List[zio.aws.kendra.model.SalesforceKnowledgeArticleState]
    def standardKnowledgeArticleTypeConfiguration: Option[
      zio.aws.kendra.model.SalesforceStandardKnowledgeArticleTypeConfiguration.ReadOnly
    ]
    def customKnowledgeArticleTypeConfigurations: Option[List[
      zio.aws.kendra.model.SalesforceCustomKnowledgeArticleTypeConfiguration.ReadOnly
    ]]
    def getIncludedStates: ZIO[Any, Nothing, List[
      zio.aws.kendra.model.SalesforceKnowledgeArticleState
    ]] = ZIO.succeed(includedStates)
    def getStandardKnowledgeArticleTypeConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.SalesforceStandardKnowledgeArticleTypeConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "standardKnowledgeArticleTypeConfiguration",
      standardKnowledgeArticleTypeConfiguration
    )
    def getCustomKnowledgeArticleTypeConfigurations: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.SalesforceCustomKnowledgeArticleTypeConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "customKnowledgeArticleTypeConfigurations",
      customKnowledgeArticleTypeConfigurations
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.SalesforceKnowledgeArticleConfiguration
  ) extends zio.aws.kendra.model.SalesforceKnowledgeArticleConfiguration.ReadOnly {
    override val includedStates
        : List[zio.aws.kendra.model.SalesforceKnowledgeArticleState] = impl
      .includedStates()
      .asScala
      .map { item =>
        zio.aws.kendra.model.SalesforceKnowledgeArticleState.wrap(item)
      }
      .toList
    override val standardKnowledgeArticleTypeConfiguration: Option[
      zio.aws.kendra.model.SalesforceStandardKnowledgeArticleTypeConfiguration.ReadOnly
    ] = scala
      .Option(impl.standardKnowledgeArticleTypeConfiguration())
      .map(value =>
        zio.aws.kendra.model.SalesforceStandardKnowledgeArticleTypeConfiguration
          .wrap(value)
      )
    override val customKnowledgeArticleTypeConfigurations: Option[List[
      zio.aws.kendra.model.SalesforceCustomKnowledgeArticleTypeConfiguration.ReadOnly
    ]] = scala
      .Option(impl.customKnowledgeArticleTypeConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.SalesforceCustomKnowledgeArticleTypeConfiguration
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.SalesforceKnowledgeArticleConfiguration
  ): zio.aws.kendra.model.SalesforceKnowledgeArticleConfiguration.ReadOnly =
    new Wrapper(impl)
}
