package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.DataSourceFieldName
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SalesforceStandardObjectConfiguration(
    name: zio.aws.kendra.model.SalesforceStandardObjectName,
    documentDataFieldName: DataSourceFieldName,
    documentTitleFieldName: Option[DataSourceFieldName] = None,
    fieldMappings: Option[
      Iterable[zio.aws.kendra.model.DataSourceToIndexFieldMapping]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectConfiguration = {
    import SalesforceStandardObjectConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectConfiguration
      .builder()
      .name(name.unwrap)
      .documentDataFieldName(
        DataSourceFieldName.unwrap(documentDataFieldName): java.lang.String
      )
      .optionallyWith(
        documentTitleFieldName.map(value =>
          DataSourceFieldName.unwrap(value): java.lang.String
        )
      )(_.documentTitleFieldName)
      .optionallyWith(
        fieldMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fieldMappings)
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.SalesforceStandardObjectConfiguration.ReadOnly =
    zio.aws.kendra.model.SalesforceStandardObjectConfiguration
      .wrap(buildAwsValue())
}
object SalesforceStandardObjectConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.SalesforceStandardObjectConfiguration =
      zio.aws.kendra.model.SalesforceStandardObjectConfiguration(
        name,
        documentDataFieldName,
        documentTitleFieldName.map(value => value),
        fieldMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: zio.aws.kendra.model.SalesforceStandardObjectName
    def documentDataFieldName: DataSourceFieldName
    def documentTitleFieldName: Option[DataSourceFieldName]
    def fieldMappings: Option[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ]
    def getName
        : ZIO[Any, Nothing, zio.aws.kendra.model.SalesforceStandardObjectName] =
      ZIO.succeed(name)
    def getDocumentDataFieldName: ZIO[Any, Nothing, DataSourceFieldName] =
      ZIO.succeed(documentDataFieldName)
    def getDocumentTitleFieldName: ZIO[Any, AwsError, DataSourceFieldName] =
      AwsError.unwrapOptionField(
        "documentTitleFieldName",
        documentTitleFieldName
      )
    def getFieldMappings: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly
    ]] = AwsError.unwrapOptionField("fieldMappings", fieldMappings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectConfiguration
  ) extends zio.aws.kendra.model.SalesforceStandardObjectConfiguration.ReadOnly {
    override val name: zio.aws.kendra.model.SalesforceStandardObjectName =
      zio.aws.kendra.model.SalesforceStandardObjectName.wrap(impl.name())
    override val documentDataFieldName: DataSourceFieldName =
      zio.aws.kendra.model.primitives
        .DataSourceFieldName(impl.documentDataFieldName())
    override val documentTitleFieldName: Option[DataSourceFieldName] = scala
      .Option(impl.documentTitleFieldName())
      .map(value => zio.aws.kendra.model.primitives.DataSourceFieldName(value))
    override val fieldMappings: Option[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ] = scala
      .Option(impl.fieldMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.DataSourceToIndexFieldMapping.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectConfiguration
  ): zio.aws.kendra.model.SalesforceStandardObjectConfiguration.ReadOnly =
    new Wrapper(impl)
}
