package zio.aws.kendra.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Search(
    facetable: Option[Boolean] = None,
    searchable: Option[Boolean] = None,
    displayable: Option[Boolean] = None,
    sortable: Option[Boolean] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.kendra.model.Search = {
    import Search.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.Search
      .builder()
      .optionallyWith(facetable.map(value => value: java.lang.Boolean))(
        _.facetable
      )
      .optionallyWith(searchable.map(value => value: java.lang.Boolean))(
        _.searchable
      )
      .optionallyWith(displayable.map(value => value: java.lang.Boolean))(
        _.displayable
      )
      .optionallyWith(sortable.map(value => value: java.lang.Boolean))(
        _.sortable
      )
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.Search.ReadOnly =
    zio.aws.kendra.model.Search.wrap(buildAwsValue())
}
object Search {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kendra.model.Search] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.Search = zio.aws.kendra.model.Search(
      facetable.map(value => value),
      searchable.map(value => value),
      displayable.map(value => value),
      sortable.map(value => value)
    )
    def facetable: Option[Boolean]
    def searchable: Option[Boolean]
    def displayable: Option[Boolean]
    def sortable: Option[Boolean]
    def getFacetable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("facetable", facetable)
    def getSearchable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("searchable", searchable)
    def getDisplayable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("displayable", displayable)
    def getSortable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("sortable", sortable)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.Search
  ) extends zio.aws.kendra.model.Search.ReadOnly {
    override val facetable: Option[Boolean] =
      scala.Option(impl.facetable()).map(value => value: Boolean)
    override val searchable: Option[Boolean] =
      scala.Option(impl.searchable()).map(value => value: Boolean)
    override val displayable: Option[Boolean] =
      scala.Option(impl.displayable()).map(value => value: Boolean)
    override val sortable: Option[Boolean] =
      scala.Option(impl.sortable()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.Search
  ): zio.aws.kendra.model.Search.ReadOnly = new Wrapper(impl)
}
