package zio.aws.kendra.model
import scala.jdk.CollectionConverters._
sealed trait ServiceNowAuthenticationType {
  def unwrap: software.amazon.awssdk.services.kendra.model.ServiceNowAuthenticationType
}
object ServiceNowAuthenticationType {
  def wrap(
      value: software.amazon.awssdk.services.kendra.model.ServiceNowAuthenticationType
  ): zio.aws.kendra.model.ServiceNowAuthenticationType = value match {
    case software.amazon.awssdk.services.kendra.model.ServiceNowAuthenticationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kendra.model.ServiceNowAuthenticationType.HTTP_BASIC =>
      val r = HTTP_BASIC
      r
    case software.amazon.awssdk.services.kendra.model.ServiceNowAuthenticationType.OAUTH2 =>
      val r = OAUTH2
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.kendra.model.ServiceNowAuthenticationType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.ServiceNowAuthenticationType =
      software.amazon.awssdk.services.kendra.model.ServiceNowAuthenticationType.UNKNOWN_TO_SDK_VERSION
  }
  case object HTTP_BASIC
      extends zio.aws.kendra.model.ServiceNowAuthenticationType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.ServiceNowAuthenticationType =
      software.amazon.awssdk.services.kendra.model.ServiceNowAuthenticationType.HTTP_BASIC
  }
  case object OAUTH2 extends zio.aws.kendra.model.ServiceNowAuthenticationType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.ServiceNowAuthenticationType =
      software.amazon.awssdk.services.kendra.model.ServiceNowAuthenticationType.OAUTH2
  }
}
