package zio.aws.kendra.model
import scala.jdk.CollectionConverters._
sealed trait ServiceNowBuildVersionType {
  def unwrap
      : software.amazon.awssdk.services.kendra.model.ServiceNowBuildVersionType
}
object ServiceNowBuildVersionType {
  def wrap(
      value: software.amazon.awssdk.services.kendra.model.ServiceNowBuildVersionType
  ): zio.aws.kendra.model.ServiceNowBuildVersionType = value match {
    case software.amazon.awssdk.services.kendra.model.ServiceNowBuildVersionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kendra.model.ServiceNowBuildVersionType.LONDON =>
      val r = LONDON
      r
    case software.amazon.awssdk.services.kendra.model.ServiceNowBuildVersionType.OTHERS =>
      val r = OTHERS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.kendra.model.ServiceNowBuildVersionType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.ServiceNowBuildVersionType =
      software.amazon.awssdk.services.kendra.model.ServiceNowBuildVersionType.UNKNOWN_TO_SDK_VERSION
  }
  case object LONDON extends zio.aws.kendra.model.ServiceNowBuildVersionType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.ServiceNowBuildVersionType =
      software.amazon.awssdk.services.kendra.model.ServiceNowBuildVersionType.LONDON
  }
  case object OTHERS extends zio.aws.kendra.model.ServiceNowBuildVersionType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.ServiceNowBuildVersionType =
      software.amazon.awssdk.services.kendra.model.ServiceNowBuildVersionType.OTHERS
  }
}
