package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{SecretArn, ServiceNowHostUrl}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ServiceNowConfiguration(
    hostUrl: ServiceNowHostUrl,
    secretArn: SecretArn,
    serviceNowBuildVersion: zio.aws.kendra.model.ServiceNowBuildVersionType,
    knowledgeArticleConfiguration: Option[
      zio.aws.kendra.model.ServiceNowKnowledgeArticleConfiguration
    ] = None,
    serviceCatalogConfiguration: Option[
      zio.aws.kendra.model.ServiceNowServiceCatalogConfiguration
    ] = None,
    authenticationType: Option[
      zio.aws.kendra.model.ServiceNowAuthenticationType
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.ServiceNowConfiguration = {
    import ServiceNowConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.ServiceNowConfiguration
      .builder()
      .hostUrl(ServiceNowHostUrl.unwrap(hostUrl): java.lang.String)
      .secretArn(SecretArn.unwrap(secretArn): java.lang.String)
      .serviceNowBuildVersion(serviceNowBuildVersion.unwrap)
      .optionallyWith(
        knowledgeArticleConfiguration.map(value => value.buildAwsValue())
      )(_.knowledgeArticleConfiguration)
      .optionallyWith(
        serviceCatalogConfiguration.map(value => value.buildAwsValue())
      )(_.serviceCatalogConfiguration)
      .optionallyWith(authenticationType.map(value => value.unwrap))(
        _.authenticationType
      )
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.ServiceNowConfiguration.ReadOnly =
    zio.aws.kendra.model.ServiceNowConfiguration.wrap(buildAwsValue())
}
object ServiceNowConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.ServiceNowConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.ServiceNowConfiguration =
      zio.aws.kendra.model.ServiceNowConfiguration(
        hostUrl,
        secretArn,
        serviceNowBuildVersion,
        knowledgeArticleConfiguration.map(value => value.asEditable),
        serviceCatalogConfiguration.map(value => value.asEditable),
        authenticationType.map(value => value)
      )
    def hostUrl: ServiceNowHostUrl
    def secretArn: SecretArn
    def serviceNowBuildVersion: zio.aws.kendra.model.ServiceNowBuildVersionType
    def knowledgeArticleConfiguration: Option[
      zio.aws.kendra.model.ServiceNowKnowledgeArticleConfiguration.ReadOnly
    ]
    def serviceCatalogConfiguration: Option[
      zio.aws.kendra.model.ServiceNowServiceCatalogConfiguration.ReadOnly
    ]
    def authenticationType
        : Option[zio.aws.kendra.model.ServiceNowAuthenticationType]
    def getHostUrl: ZIO[Any, Nothing, ServiceNowHostUrl] = ZIO.succeed(hostUrl)
    def getSecretArn: ZIO[Any, Nothing, SecretArn] = ZIO.succeed(secretArn)
    def getServiceNowBuildVersion
        : ZIO[Any, Nothing, zio.aws.kendra.model.ServiceNowBuildVersionType] =
      ZIO.succeed(serviceNowBuildVersion)
    def getKnowledgeArticleConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.ServiceNowKnowledgeArticleConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "knowledgeArticleConfiguration",
      knowledgeArticleConfiguration
    )
    def getServiceCatalogConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.ServiceNowServiceCatalogConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "serviceCatalogConfiguration",
      serviceCatalogConfiguration
    )
    def getAuthenticationType: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.ServiceNowAuthenticationType
    ] = AwsError.unwrapOptionField("authenticationType", authenticationType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.ServiceNowConfiguration
  ) extends zio.aws.kendra.model.ServiceNowConfiguration.ReadOnly {
    override val hostUrl: ServiceNowHostUrl =
      zio.aws.kendra.model.primitives.ServiceNowHostUrl(impl.hostUrl())
    override val secretArn: SecretArn =
      zio.aws.kendra.model.primitives.SecretArn(impl.secretArn())
    override val serviceNowBuildVersion
        : zio.aws.kendra.model.ServiceNowBuildVersionType =
      zio.aws.kendra.model.ServiceNowBuildVersionType
        .wrap(impl.serviceNowBuildVersion())
    override val knowledgeArticleConfiguration: Option[
      zio.aws.kendra.model.ServiceNowKnowledgeArticleConfiguration.ReadOnly
    ] = scala
      .Option(impl.knowledgeArticleConfiguration())
      .map(value =>
        zio.aws.kendra.model.ServiceNowKnowledgeArticleConfiguration.wrap(value)
      )
    override val serviceCatalogConfiguration: Option[
      zio.aws.kendra.model.ServiceNowServiceCatalogConfiguration.ReadOnly
    ] = scala
      .Option(impl.serviceCatalogConfiguration())
      .map(value =>
        zio.aws.kendra.model.ServiceNowServiceCatalogConfiguration.wrap(value)
      )
    override val authenticationType
        : Option[zio.aws.kendra.model.ServiceNowAuthenticationType] = scala
      .Option(impl.authenticationType())
      .map(value =>
        zio.aws.kendra.model.ServiceNowAuthenticationType.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.ServiceNowConfiguration
  ): zio.aws.kendra.model.ServiceNowConfiguration.ReadOnly = new Wrapper(impl)
}
