package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  ServiceNowKnowledgeArticleFilterQuery,
  DataSourceFieldName,
  DataSourceInclusionsExclusionsStringsMember
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ServiceNowKnowledgeArticleConfiguration(
    crawlAttachments: Option[Boolean] = None,
    includeAttachmentFilePatterns: Option[
      Iterable[DataSourceInclusionsExclusionsStringsMember]
    ] = None,
    excludeAttachmentFilePatterns: Option[
      Iterable[DataSourceInclusionsExclusionsStringsMember]
    ] = None,
    documentDataFieldName: DataSourceFieldName,
    documentTitleFieldName: Option[DataSourceFieldName] = None,
    fieldMappings: Option[
      Iterable[zio.aws.kendra.model.DataSourceToIndexFieldMapping]
    ] = None,
    filterQuery: Option[ServiceNowKnowledgeArticleFilterQuery] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.ServiceNowKnowledgeArticleConfiguration = {
    import ServiceNowKnowledgeArticleConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.ServiceNowKnowledgeArticleConfiguration
      .builder()
      .optionallyWith(crawlAttachments.map(value => value: java.lang.Boolean))(
        _.crawlAttachments
      )
      .optionallyWith(
        includeAttachmentFilePatterns.map(value =>
          value.map { item =>
            DataSourceInclusionsExclusionsStringsMember.unwrap(
              item
            ): java.lang.String
          }.asJavaCollection
        )
      )(_.includeAttachmentFilePatterns)
      .optionallyWith(
        excludeAttachmentFilePatterns.map(value =>
          value.map { item =>
            DataSourceInclusionsExclusionsStringsMember.unwrap(
              item
            ): java.lang.String
          }.asJavaCollection
        )
      )(_.excludeAttachmentFilePatterns)
      .documentDataFieldName(
        DataSourceFieldName.unwrap(documentDataFieldName): java.lang.String
      )
      .optionallyWith(
        documentTitleFieldName.map(value =>
          DataSourceFieldName.unwrap(value): java.lang.String
        )
      )(_.documentTitleFieldName)
      .optionallyWith(
        fieldMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fieldMappings)
      .optionallyWith(
        filterQuery.map(value =>
          ServiceNowKnowledgeArticleFilterQuery.unwrap(value): java.lang.String
        )
      )(_.filterQuery)
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.ServiceNowKnowledgeArticleConfiguration.ReadOnly =
    zio.aws.kendra.model.ServiceNowKnowledgeArticleConfiguration
      .wrap(buildAwsValue())
}
object ServiceNowKnowledgeArticleConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.ServiceNowKnowledgeArticleConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kendra.model.ServiceNowKnowledgeArticleConfiguration =
      zio.aws.kendra.model.ServiceNowKnowledgeArticleConfiguration(
        crawlAttachments.map(value => value),
        includeAttachmentFilePatterns.map(value => value),
        excludeAttachmentFilePatterns.map(value => value),
        documentDataFieldName,
        documentTitleFieldName.map(value => value),
        fieldMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        filterQuery.map(value => value)
      )
    def crawlAttachments: Option[Boolean]
    def includeAttachmentFilePatterns
        : Option[List[DataSourceInclusionsExclusionsStringsMember]]
    def excludeAttachmentFilePatterns
        : Option[List[DataSourceInclusionsExclusionsStringsMember]]
    def documentDataFieldName: DataSourceFieldName
    def documentTitleFieldName: Option[DataSourceFieldName]
    def fieldMappings: Option[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ]
    def filterQuery: Option[ServiceNowKnowledgeArticleFilterQuery]
    def getCrawlAttachments: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("crawlAttachments", crawlAttachments)
    def getIncludeAttachmentFilePatterns: ZIO[Any, AwsError, List[
      DataSourceInclusionsExclusionsStringsMember
    ]] = AwsError.unwrapOptionField(
      "includeAttachmentFilePatterns",
      includeAttachmentFilePatterns
    )
    def getExcludeAttachmentFilePatterns: ZIO[Any, AwsError, List[
      DataSourceInclusionsExclusionsStringsMember
    ]] = AwsError.unwrapOptionField(
      "excludeAttachmentFilePatterns",
      excludeAttachmentFilePatterns
    )
    def getDocumentDataFieldName: ZIO[Any, Nothing, DataSourceFieldName] =
      ZIO.succeed(documentDataFieldName)
    def getDocumentTitleFieldName: ZIO[Any, AwsError, DataSourceFieldName] =
      AwsError.unwrapOptionField(
        "documentTitleFieldName",
        documentTitleFieldName
      )
    def getFieldMappings: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly
    ]] = AwsError.unwrapOptionField("fieldMappings", fieldMappings)
    def getFilterQuery
        : ZIO[Any, AwsError, ServiceNowKnowledgeArticleFilterQuery] =
      AwsError.unwrapOptionField("filterQuery", filterQuery)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.ServiceNowKnowledgeArticleConfiguration
  ) extends zio.aws.kendra.model.ServiceNowKnowledgeArticleConfiguration.ReadOnly {
    override val crawlAttachments: Option[Boolean] =
      scala.Option(impl.crawlAttachments()).map(value => value: Boolean)
    override val includeAttachmentFilePatterns
        : Option[List[DataSourceInclusionsExclusionsStringsMember]] = scala
      .Option(impl.includeAttachmentFilePatterns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.primitives
            .DataSourceInclusionsExclusionsStringsMember(item)
        }.toList
      )
    override val excludeAttachmentFilePatterns
        : Option[List[DataSourceInclusionsExclusionsStringsMember]] = scala
      .Option(impl.excludeAttachmentFilePatterns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.primitives
            .DataSourceInclusionsExclusionsStringsMember(item)
        }.toList
      )
    override val documentDataFieldName: DataSourceFieldName =
      zio.aws.kendra.model.primitives
        .DataSourceFieldName(impl.documentDataFieldName())
    override val documentTitleFieldName: Option[DataSourceFieldName] = scala
      .Option(impl.documentTitleFieldName())
      .map(value => zio.aws.kendra.model.primitives.DataSourceFieldName(value))
    override val fieldMappings: Option[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ] = scala
      .Option(impl.fieldMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.DataSourceToIndexFieldMapping.wrap(item)
        }.toList
      )
    override val filterQuery: Option[ServiceNowKnowledgeArticleFilterQuery] =
      scala
        .Option(impl.filterQuery())
        .map(value =>
          zio.aws.kendra.model.primitives
            .ServiceNowKnowledgeArticleFilterQuery(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.ServiceNowKnowledgeArticleConfiguration
  ): zio.aws.kendra.model.ServiceNowKnowledgeArticleConfiguration.ReadOnly =
    new Wrapper(impl)
}
