package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  DataSourceFieldName,
  DataSourceInclusionsExclusionsStringsMember,
  SecretArn,
  Url
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SharePointConfiguration(
    sharePointVersion: zio.aws.kendra.model.SharePointVersion,
    urls: Iterable[Url],
    secretArn: SecretArn,
    crawlAttachments: Option[Boolean] = None,
    useChangeLog: Option[Boolean] = None,
    inclusionPatterns: Option[
      Iterable[DataSourceInclusionsExclusionsStringsMember]
    ] = None,
    exclusionPatterns: Option[
      Iterable[DataSourceInclusionsExclusionsStringsMember]
    ] = None,
    vpcConfiguration: Option[zio.aws.kendra.model.DataSourceVpcConfiguration] =
      None,
    fieldMappings: Option[
      Iterable[zio.aws.kendra.model.DataSourceToIndexFieldMapping]
    ] = None,
    documentTitleFieldName: Option[DataSourceFieldName] = None,
    disableLocalGroups: Option[Boolean] = None,
    sslCertificateS3Path: Option[zio.aws.kendra.model.S3Path] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.SharePointConfiguration = {
    import SharePointConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.SharePointConfiguration
      .builder()
      .sharePointVersion(sharePointVersion.unwrap)
      .urls(urls.map { item =>
        Url.unwrap(item): java.lang.String
      }.asJavaCollection)
      .secretArn(SecretArn.unwrap(secretArn): java.lang.String)
      .optionallyWith(crawlAttachments.map(value => value: java.lang.Boolean))(
        _.crawlAttachments
      )
      .optionallyWith(useChangeLog.map(value => value: java.lang.Boolean))(
        _.useChangeLog
      )
      .optionallyWith(
        inclusionPatterns.map(value =>
          value.map { item =>
            DataSourceInclusionsExclusionsStringsMember.unwrap(
              item
            ): java.lang.String
          }.asJavaCollection
        )
      )(_.inclusionPatterns)
      .optionallyWith(
        exclusionPatterns.map(value =>
          value.map { item =>
            DataSourceInclusionsExclusionsStringsMember.unwrap(
              item
            ): java.lang.String
          }.asJavaCollection
        )
      )(_.exclusionPatterns)
      .optionallyWith(vpcConfiguration.map(value => value.buildAwsValue()))(
        _.vpcConfiguration
      )
      .optionallyWith(
        fieldMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fieldMappings)
      .optionallyWith(
        documentTitleFieldName.map(value =>
          DataSourceFieldName.unwrap(value): java.lang.String
        )
      )(_.documentTitleFieldName)
      .optionallyWith(
        disableLocalGroups.map(value => value: java.lang.Boolean)
      )(_.disableLocalGroups)
      .optionallyWith(sslCertificateS3Path.map(value => value.buildAwsValue()))(
        _.sslCertificateS3Path
      )
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.SharePointConfiguration.ReadOnly =
    zio.aws.kendra.model.SharePointConfiguration.wrap(buildAwsValue())
}
object SharePointConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.SharePointConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.SharePointConfiguration =
      zio.aws.kendra.model.SharePointConfiguration(
        sharePointVersion,
        urls,
        secretArn,
        crawlAttachments.map(value => value),
        useChangeLog.map(value => value),
        inclusionPatterns.map(value => value),
        exclusionPatterns.map(value => value),
        vpcConfiguration.map(value => value.asEditable),
        fieldMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        documentTitleFieldName.map(value => value),
        disableLocalGroups.map(value => value),
        sslCertificateS3Path.map(value => value.asEditable)
      )
    def sharePointVersion: zio.aws.kendra.model.SharePointVersion
    def urls: List[Url]
    def secretArn: SecretArn
    def crawlAttachments: Option[Boolean]
    def useChangeLog: Option[Boolean]
    def inclusionPatterns
        : Option[List[DataSourceInclusionsExclusionsStringsMember]]
    def exclusionPatterns
        : Option[List[DataSourceInclusionsExclusionsStringsMember]]
    def vpcConfiguration
        : Option[zio.aws.kendra.model.DataSourceVpcConfiguration.ReadOnly]
    def fieldMappings: Option[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ]
    def documentTitleFieldName: Option[DataSourceFieldName]
    def disableLocalGroups: Option[Boolean]
    def sslCertificateS3Path: Option[zio.aws.kendra.model.S3Path.ReadOnly]
    def getSharePointVersion
        : ZIO[Any, Nothing, zio.aws.kendra.model.SharePointVersion] =
      ZIO.succeed(sharePointVersion)
    def getUrls: ZIO[Any, Nothing, List[Url]] = ZIO.succeed(urls)
    def getSecretArn: ZIO[Any, Nothing, SecretArn] = ZIO.succeed(secretArn)
    def getCrawlAttachments: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("crawlAttachments", crawlAttachments)
    def getUseChangeLog: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("useChangeLog", useChangeLog)
    def getInclusionPatterns: ZIO[Any, AwsError, List[
      DataSourceInclusionsExclusionsStringsMember
    ]] = AwsError.unwrapOptionField("inclusionPatterns", inclusionPatterns)
    def getExclusionPatterns: ZIO[Any, AwsError, List[
      DataSourceInclusionsExclusionsStringsMember
    ]] = AwsError.unwrapOptionField("exclusionPatterns", exclusionPatterns)
    def getVpcConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.DataSourceVpcConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("vpcConfiguration", vpcConfiguration)
    def getFieldMappings: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly
    ]] = AwsError.unwrapOptionField("fieldMappings", fieldMappings)
    def getDocumentTitleFieldName: ZIO[Any, AwsError, DataSourceFieldName] =
      AwsError.unwrapOptionField(
        "documentTitleFieldName",
        documentTitleFieldName
      )
    def getDisableLocalGroups: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("disableLocalGroups", disableLocalGroups)
    def getSslCertificateS3Path
        : ZIO[Any, AwsError, zio.aws.kendra.model.S3Path.ReadOnly] =
      AwsError.unwrapOptionField("sslCertificateS3Path", sslCertificateS3Path)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.SharePointConfiguration
  ) extends zio.aws.kendra.model.SharePointConfiguration.ReadOnly {
    override val sharePointVersion: zio.aws.kendra.model.SharePointVersion =
      zio.aws.kendra.model.SharePointVersion.wrap(impl.sharePointVersion())
    override val urls: List[Url] = impl
      .urls()
      .asScala
      .map { item =>
        zio.aws.kendra.model.primitives.Url(item)
      }
      .toList
    override val secretArn: SecretArn =
      zio.aws.kendra.model.primitives.SecretArn(impl.secretArn())
    override val crawlAttachments: Option[Boolean] =
      scala.Option(impl.crawlAttachments()).map(value => value: Boolean)
    override val useChangeLog: Option[Boolean] =
      scala.Option(impl.useChangeLog()).map(value => value: Boolean)
    override val inclusionPatterns
        : Option[List[DataSourceInclusionsExclusionsStringsMember]] = scala
      .Option(impl.inclusionPatterns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.primitives
            .DataSourceInclusionsExclusionsStringsMember(item)
        }.toList
      )
    override val exclusionPatterns
        : Option[List[DataSourceInclusionsExclusionsStringsMember]] = scala
      .Option(impl.exclusionPatterns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.primitives
            .DataSourceInclusionsExclusionsStringsMember(item)
        }.toList
      )
    override val vpcConfiguration
        : Option[zio.aws.kendra.model.DataSourceVpcConfiguration.ReadOnly] =
      scala
        .Option(impl.vpcConfiguration())
        .map(value =>
          zio.aws.kendra.model.DataSourceVpcConfiguration.wrap(value)
        )
    override val fieldMappings: Option[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ] = scala
      .Option(impl.fieldMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.DataSourceToIndexFieldMapping.wrap(item)
        }.toList
      )
    override val documentTitleFieldName: Option[DataSourceFieldName] = scala
      .Option(impl.documentTitleFieldName())
      .map(value => zio.aws.kendra.model.primitives.DataSourceFieldName(value))
    override val disableLocalGroups: Option[Boolean] =
      scala.Option(impl.disableLocalGroups()).map(value => value: Boolean)
    override val sslCertificateS3Path
        : Option[zio.aws.kendra.model.S3Path.ReadOnly] = scala
      .Option(impl.sslCertificateS3Path())
      .map(value => zio.aws.kendra.model.S3Path.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.SharePointConfiguration
  ): zio.aws.kendra.model.SharePointConfiguration.ReadOnly = new Wrapper(impl)
}
