package zio.aws.kendra.model
import scala.jdk.CollectionConverters._
sealed trait SharePointVersion {
  def unwrap: software.amazon.awssdk.services.kendra.model.SharePointVersion
}
object SharePointVersion {
  def wrap(
      value: software.amazon.awssdk.services.kendra.model.SharePointVersion
  ): zio.aws.kendra.model.SharePointVersion = value match {
    case software.amazon.awssdk.services.kendra.model.SharePointVersion.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kendra.model.SharePointVersion.SHAREPOINT_2013 =>
      val r = SHAREPOINT_2013
      r
    case software.amazon.awssdk.services.kendra.model.SharePointVersion.SHAREPOINT_2016 =>
      val r = SHAREPOINT_2016
      r
    case software.amazon.awssdk.services.kendra.model.SharePointVersion.SHAREPOINT_ONLINE =>
      val r = SHAREPOINT_ONLINE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.kendra.model.SharePointVersion {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.SharePointVersion =
      software.amazon.awssdk.services.kendra.model.SharePointVersion.UNKNOWN_TO_SDK_VERSION
  }
  case object SHAREPOINT_2013 extends zio.aws.kendra.model.SharePointVersion {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.SharePointVersion =
      software.amazon.awssdk.services.kendra.model.SharePointVersion.SHAREPOINT_2013
  }
  case object SHAREPOINT_2016 extends zio.aws.kendra.model.SharePointVersion {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.SharePointVersion =
      software.amazon.awssdk.services.kendra.model.SharePointVersion.SHAREPOINT_2016
  }
  case object SHAREPOINT_ONLINE extends zio.aws.kendra.model.SharePointVersion {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.SharePointVersion =
      software.amazon.awssdk.services.kendra.model.SharePointVersion.SHAREPOINT_ONLINE
  }
}
