package zio.aws.kendra.model
import java.lang.Integer
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  SecretArn,
  LookBackPeriod,
  TeamId,
  DataSourceInclusionsExclusionsStringsMember,
  SinceCrawlDate
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SlackConfiguration(
    teamId: TeamId,
    secretArn: SecretArn,
    vpcConfiguration: Option[zio.aws.kendra.model.DataSourceVpcConfiguration] =
      None,
    slackEntityList: Iterable[zio.aws.kendra.model.SlackEntity],
    useChangeLog: Option[Boolean] = None,
    crawlBotMessage: Option[Boolean] = None,
    excludeArchived: Option[Boolean] = None,
    sinceCrawlDate: SinceCrawlDate,
    lookBackPeriod: Option[LookBackPeriod] = None,
    privateChannelFilter: Option[Iterable[String]] = None,
    publicChannelFilter: Option[Iterable[String]] = None,
    inclusionPatterns: Option[
      Iterable[DataSourceInclusionsExclusionsStringsMember]
    ] = None,
    exclusionPatterns: Option[
      Iterable[DataSourceInclusionsExclusionsStringsMember]
    ] = None,
    fieldMappings: Option[
      Iterable[zio.aws.kendra.model.DataSourceToIndexFieldMapping]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.SlackConfiguration = {
    import SlackConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.SlackConfiguration
      .builder()
      .teamId(TeamId.unwrap(teamId): java.lang.String)
      .secretArn(SecretArn.unwrap(secretArn): java.lang.String)
      .optionallyWith(vpcConfiguration.map(value => value.buildAwsValue()))(
        _.vpcConfiguration
      )
      .slackEntityListWithStrings(slackEntityList.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .optionallyWith(useChangeLog.map(value => value: java.lang.Boolean))(
        _.useChangeLog
      )
      .optionallyWith(crawlBotMessage.map(value => value: java.lang.Boolean))(
        _.crawlBotMessage
      )
      .optionallyWith(excludeArchived.map(value => value: java.lang.Boolean))(
        _.excludeArchived
      )
      .sinceCrawlDate(SinceCrawlDate.unwrap(sinceCrawlDate): java.lang.String)
      .optionallyWith(
        lookBackPeriod.map(value => LookBackPeriod.unwrap(value): Integer)
      )(_.lookBackPeriod)
      .optionallyWith(
        privateChannelFilter.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.privateChannelFilter)
      .optionallyWith(
        publicChannelFilter.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.publicChannelFilter)
      .optionallyWith(
        inclusionPatterns.map(value =>
          value.map { item =>
            DataSourceInclusionsExclusionsStringsMember.unwrap(
              item
            ): java.lang.String
          }.asJavaCollection
        )
      )(_.inclusionPatterns)
      .optionallyWith(
        exclusionPatterns.map(value =>
          value.map { item =>
            DataSourceInclusionsExclusionsStringsMember.unwrap(
              item
            ): java.lang.String
          }.asJavaCollection
        )
      )(_.exclusionPatterns)
      .optionallyWith(
        fieldMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fieldMappings)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.SlackConfiguration.ReadOnly =
    zio.aws.kendra.model.SlackConfiguration.wrap(buildAwsValue())
}
object SlackConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.SlackConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.SlackConfiguration =
      zio.aws.kendra.model.SlackConfiguration(
        teamId,
        secretArn,
        vpcConfiguration.map(value => value.asEditable),
        slackEntityList,
        useChangeLog.map(value => value),
        crawlBotMessage.map(value => value),
        excludeArchived.map(value => value),
        sinceCrawlDate,
        lookBackPeriod.map(value => value),
        privateChannelFilter.map(value => value),
        publicChannelFilter.map(value => value),
        inclusionPatterns.map(value => value),
        exclusionPatterns.map(value => value),
        fieldMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def teamId: TeamId
    def secretArn: SecretArn
    def vpcConfiguration
        : Option[zio.aws.kendra.model.DataSourceVpcConfiguration.ReadOnly]
    def slackEntityList: List[zio.aws.kendra.model.SlackEntity]
    def useChangeLog: Option[Boolean]
    def crawlBotMessage: Option[Boolean]
    def excludeArchived: Option[Boolean]
    def sinceCrawlDate: SinceCrawlDate
    def lookBackPeriod: Option[LookBackPeriod]
    def privateChannelFilter: Option[List[String]]
    def publicChannelFilter: Option[List[String]]
    def inclusionPatterns
        : Option[List[DataSourceInclusionsExclusionsStringsMember]]
    def exclusionPatterns
        : Option[List[DataSourceInclusionsExclusionsStringsMember]]
    def fieldMappings: Option[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ]
    def getTeamId: ZIO[Any, Nothing, TeamId] = ZIO.succeed(teamId)
    def getSecretArn: ZIO[Any, Nothing, SecretArn] = ZIO.succeed(secretArn)
    def getVpcConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.DataSourceVpcConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("vpcConfiguration", vpcConfiguration)
    def getSlackEntityList
        : ZIO[Any, Nothing, List[zio.aws.kendra.model.SlackEntity]] =
      ZIO.succeed(slackEntityList)
    def getUseChangeLog: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("useChangeLog", useChangeLog)
    def getCrawlBotMessage: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("crawlBotMessage", crawlBotMessage)
    def getExcludeArchived: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("excludeArchived", excludeArchived)
    def getSinceCrawlDate: ZIO[Any, Nothing, SinceCrawlDate] =
      ZIO.succeed(sinceCrawlDate)
    def getLookBackPeriod: ZIO[Any, AwsError, LookBackPeriod] =
      AwsError.unwrapOptionField("lookBackPeriod", lookBackPeriod)
    def getPrivateChannelFilter: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("privateChannelFilter", privateChannelFilter)
    def getPublicChannelFilter: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("publicChannelFilter", publicChannelFilter)
    def getInclusionPatterns: ZIO[Any, AwsError, List[
      DataSourceInclusionsExclusionsStringsMember
    ]] = AwsError.unwrapOptionField("inclusionPatterns", inclusionPatterns)
    def getExclusionPatterns: ZIO[Any, AwsError, List[
      DataSourceInclusionsExclusionsStringsMember
    ]] = AwsError.unwrapOptionField("exclusionPatterns", exclusionPatterns)
    def getFieldMappings: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly
    ]] = AwsError.unwrapOptionField("fieldMappings", fieldMappings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.SlackConfiguration
  ) extends zio.aws.kendra.model.SlackConfiguration.ReadOnly {
    override val teamId: TeamId =
      zio.aws.kendra.model.primitives.TeamId(impl.teamId())
    override val secretArn: SecretArn =
      zio.aws.kendra.model.primitives.SecretArn(impl.secretArn())
    override val vpcConfiguration
        : Option[zio.aws.kendra.model.DataSourceVpcConfiguration.ReadOnly] =
      scala
        .Option(impl.vpcConfiguration())
        .map(value =>
          zio.aws.kendra.model.DataSourceVpcConfiguration.wrap(value)
        )
    override val slackEntityList: List[zio.aws.kendra.model.SlackEntity] = impl
      .slackEntityList()
      .asScala
      .map { item =>
        zio.aws.kendra.model.SlackEntity.wrap(item)
      }
      .toList
    override val useChangeLog: Option[Boolean] =
      scala.Option(impl.useChangeLog()).map(value => value: Boolean)
    override val crawlBotMessage: Option[Boolean] =
      scala.Option(impl.crawlBotMessage()).map(value => value: Boolean)
    override val excludeArchived: Option[Boolean] =
      scala.Option(impl.excludeArchived()).map(value => value: Boolean)
    override val sinceCrawlDate: SinceCrawlDate =
      zio.aws.kendra.model.primitives.SinceCrawlDate(impl.sinceCrawlDate())
    override val lookBackPeriod: Option[LookBackPeriod] = scala
      .Option(impl.lookBackPeriod())
      .map(value => zio.aws.kendra.model.primitives.LookBackPeriod(value))
    override val privateChannelFilter: Option[List[String]] = scala
      .Option(impl.privateChannelFilter())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val publicChannelFilter: Option[List[String]] = scala
      .Option(impl.publicChannelFilter())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val inclusionPatterns
        : Option[List[DataSourceInclusionsExclusionsStringsMember]] = scala
      .Option(impl.inclusionPatterns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.primitives
            .DataSourceInclusionsExclusionsStringsMember(item)
        }.toList
      )
    override val exclusionPatterns
        : Option[List[DataSourceInclusionsExclusionsStringsMember]] = scala
      .Option(impl.exclusionPatterns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.primitives
            .DataSourceInclusionsExclusionsStringsMember(item)
        }.toList
      )
    override val fieldMappings: Option[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ] = scala
      .Option(impl.fieldMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.DataSourceToIndexFieldMapping.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.SlackConfiguration
  ): zio.aws.kendra.model.SlackConfiguration.ReadOnly = new Wrapper(impl)
}
