package zio.aws.kendra.model
import scala.jdk.CollectionConverters._
sealed trait SortOrder {
  def unwrap: software.amazon.awssdk.services.kendra.model.SortOrder
}
object SortOrder {
  def wrap(
      value: software.amazon.awssdk.services.kendra.model.SortOrder
  ): zio.aws.kendra.model.SortOrder = value match {
    case software.amazon.awssdk.services.kendra.model.SortOrder.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kendra.model.SortOrder.DESC =>
      val r = DESC
      r
    case software.amazon.awssdk.services.kendra.model.SortOrder.ASC =>
      val r = ASC
      r
  }
  case object unknownToSdkVersion extends zio.aws.kendra.model.SortOrder {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.SortOrder =
      software.amazon.awssdk.services.kendra.model.SortOrder.UNKNOWN_TO_SDK_VERSION
  }
  case object DESC extends zio.aws.kendra.model.SortOrder {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.SortOrder =
      software.amazon.awssdk.services.kendra.model.SortOrder.DESC
  }
  case object ASC extends zio.aws.kendra.model.SortOrder {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.SortOrder =
      software.amazon.awssdk.services.kendra.model.SortOrder.ASC
  }
}
