package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.DocumentAttributeKey
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SortingConfiguration(
    documentAttributeKey: DocumentAttributeKey,
    sortOrder: zio.aws.kendra.model.SortOrder
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.SortingConfiguration = {
    import SortingConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.SortingConfiguration
      .builder()
      .documentAttributeKey(
        DocumentAttributeKey.unwrap(documentAttributeKey): java.lang.String
      )
      .sortOrder(sortOrder.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.SortingConfiguration.ReadOnly =
    zio.aws.kendra.model.SortingConfiguration.wrap(buildAwsValue())
}
object SortingConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.SortingConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.SortingConfiguration =
      zio.aws.kendra.model.SortingConfiguration(documentAttributeKey, sortOrder)
    def documentAttributeKey: DocumentAttributeKey
    def sortOrder: zio.aws.kendra.model.SortOrder
    def getDocumentAttributeKey: ZIO[Any, Nothing, DocumentAttributeKey] =
      ZIO.succeed(documentAttributeKey)
    def getSortOrder: ZIO[Any, Nothing, zio.aws.kendra.model.SortOrder] =
      ZIO.succeed(sortOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.SortingConfiguration
  ) extends zio.aws.kendra.model.SortingConfiguration.ReadOnly {
    override val documentAttributeKey: DocumentAttributeKey =
      zio.aws.kendra.model.primitives
        .DocumentAttributeKey(impl.documentAttributeKey())
    override val sortOrder: zio.aws.kendra.model.SortOrder =
      zio.aws.kendra.model.SortOrder.wrap(impl.sortOrder())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.SortingConfiguration
  ): zio.aws.kendra.model.SortingConfiguration.ReadOnly = new Wrapper(impl)
}
