package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.SuggestedQueryText
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SpellCorrectedQuery(
    suggestedQueryText: Option[SuggestedQueryText] = None,
    corrections: Option[Iterable[zio.aws.kendra.model.Correction]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.SpellCorrectedQuery = {
    import SpellCorrectedQuery.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.SpellCorrectedQuery
      .builder()
      .optionallyWith(
        suggestedQueryText.map(value =>
          SuggestedQueryText.unwrap(value): java.lang.String
        )
      )(_.suggestedQueryText)
      .optionallyWith(
        corrections.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.corrections)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.SpellCorrectedQuery.ReadOnly =
    zio.aws.kendra.model.SpellCorrectedQuery.wrap(buildAwsValue())
}
object SpellCorrectedQuery {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.SpellCorrectedQuery
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.SpellCorrectedQuery =
      zio.aws.kendra.model.SpellCorrectedQuery(
        suggestedQueryText.map(value => value),
        corrections.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def suggestedQueryText: Option[SuggestedQueryText]
    def corrections: Option[List[zio.aws.kendra.model.Correction.ReadOnly]]
    def getSuggestedQueryText: ZIO[Any, AwsError, SuggestedQueryText] =
      AwsError.unwrapOptionField("suggestedQueryText", suggestedQueryText)
    def getCorrections
        : ZIO[Any, AwsError, List[zio.aws.kendra.model.Correction.ReadOnly]] =
      AwsError.unwrapOptionField("corrections", corrections)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.SpellCorrectedQuery
  ) extends zio.aws.kendra.model.SpellCorrectedQuery.ReadOnly {
    override val suggestedQueryText: Option[SuggestedQueryText] = scala
      .Option(impl.suggestedQueryText())
      .map(value => zio.aws.kendra.model.primitives.SuggestedQueryText(value))
    override val corrections
        : Option[List[zio.aws.kendra.model.Correction.ReadOnly]] = scala
      .Option(impl.corrections())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.Correction.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.SpellCorrectedQuery
  ): zio.aws.kendra.model.SpellCorrectedQuery.ReadOnly = new Wrapper(impl)
}
