package zio.aws.kendra.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SqlConfiguration(
    queryIdentifiersEnclosingOption: Option[
      zio.aws.kendra.model.QueryIdentifiersEnclosingOption
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.SqlConfiguration = {
    import SqlConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.SqlConfiguration
      .builder()
      .optionallyWith(
        queryIdentifiersEnclosingOption.map(value => value.unwrap)
      )(_.queryIdentifiersEnclosingOption)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.SqlConfiguration.ReadOnly =
    zio.aws.kendra.model.SqlConfiguration.wrap(buildAwsValue())
}
object SqlConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.SqlConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.SqlConfiguration = zio.aws.kendra.model
      .SqlConfiguration(queryIdentifiersEnclosingOption.map(value => value))
    def queryIdentifiersEnclosingOption
        : Option[zio.aws.kendra.model.QueryIdentifiersEnclosingOption]
    def getQueryIdentifiersEnclosingOption: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.QueryIdentifiersEnclosingOption
    ] = AwsError.unwrapOptionField(
      "queryIdentifiersEnclosingOption",
      queryIdentifiersEnclosingOption
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.SqlConfiguration
  ) extends zio.aws.kendra.model.SqlConfiguration.ReadOnly {
    override val queryIdentifiersEnclosingOption
        : Option[zio.aws.kendra.model.QueryIdentifiersEnclosingOption] = scala
      .Option(impl.queryIdentifiersEnclosingOption())
      .map(value =>
        zio.aws.kendra.model.QueryIdentifiersEnclosingOption.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.SqlConfiguration
  ): zio.aws.kendra.model.SqlConfiguration.ReadOnly = new Wrapper(impl)
}
