package zio.aws.kendra.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StartDataSourceSyncJobResponse(
    executionId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.StartDataSourceSyncJobResponse = {
    import StartDataSourceSyncJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.StartDataSourceSyncJobResponse
      .builder()
      .optionallyWith(executionId.map(value => value: java.lang.String))(
        _.executionId
      )
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.StartDataSourceSyncJobResponse.ReadOnly =
    zio.aws.kendra.model.StartDataSourceSyncJobResponse.wrap(buildAwsValue())
}
object StartDataSourceSyncJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.StartDataSourceSyncJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.StartDataSourceSyncJobResponse =
      zio.aws.kendra.model
        .StartDataSourceSyncJobResponse(executionId.map(value => value))
    def executionId: Option[String]
    def getExecutionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("executionId", executionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.StartDataSourceSyncJobResponse
  ) extends zio.aws.kendra.model.StartDataSourceSyncJobResponse.ReadOnly {
    override val executionId: Option[String] =
      scala.Option(impl.executionId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.StartDataSourceSyncJobResponse
  ): zio.aws.kendra.model.StartDataSourceSyncJobResponse.ReadOnly = new Wrapper(
    impl
  )
}
