package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.DocumentId
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Status(
    documentId: Option[DocumentId] = None,
    documentStatus: Option[zio.aws.kendra.model.DocumentStatus] = None,
    failureCode: Option[String] = None,
    failureReason: Option[String] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.kendra.model.Status = {
    import Status.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.Status
      .builder()
      .optionallyWith(
        documentId.map(value => DocumentId.unwrap(value): java.lang.String)
      )(_.documentId)
      .optionallyWith(documentStatus.map(value => value.unwrap))(
        _.documentStatus
      )
      .optionallyWith(failureCode.map(value => value: java.lang.String))(
        _.failureCode
      )
      .optionallyWith(failureReason.map(value => value: java.lang.String))(
        _.failureReason
      )
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.Status.ReadOnly =
    zio.aws.kendra.model.Status.wrap(buildAwsValue())
}
object Status {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kendra.model.Status] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.Status = zio.aws.kendra.model.Status(
      documentId.map(value => value),
      documentStatus.map(value => value),
      failureCode.map(value => value),
      failureReason.map(value => value)
    )
    def documentId: Option[DocumentId]
    def documentStatus: Option[zio.aws.kendra.model.DocumentStatus]
    def failureCode: Option[String]
    def failureReason: Option[String]
    def getDocumentId: ZIO[Any, AwsError, DocumentId] =
      AwsError.unwrapOptionField("documentId", documentId)
    def getDocumentStatus
        : ZIO[Any, AwsError, zio.aws.kendra.model.DocumentStatus] =
      AwsError.unwrapOptionField("documentStatus", documentStatus)
    def getFailureCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("failureCode", failureCode)
    def getFailureReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("failureReason", failureReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.Status
  ) extends zio.aws.kendra.model.Status.ReadOnly {
    override val documentId: Option[DocumentId] = scala
      .Option(impl.documentId())
      .map(value => zio.aws.kendra.model.primitives.DocumentId(value))
    override val documentStatus: Option[zio.aws.kendra.model.DocumentStatus] =
      scala
        .Option(impl.documentStatus())
        .map(value => zio.aws.kendra.model.DocumentStatus.wrap(value))
    override val failureCode: Option[String] =
      scala.Option(impl.failureCode()).map(value => value: String)
    override val failureReason: Option[String] =
      scala.Option(impl.failureReason()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.Status
  ): zio.aws.kendra.model.Status.ReadOnly = new Wrapper(impl)
}
