package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{IndexId, DataSourceId}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StopDataSourceSyncJobRequest(
    id: DataSourceId,
    indexId: IndexId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.StopDataSourceSyncJobRequest = {
    import StopDataSourceSyncJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.StopDataSourceSyncJobRequest
      .builder()
      .id(DataSourceId.unwrap(id): java.lang.String)
      .indexId(IndexId.unwrap(indexId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.StopDataSourceSyncJobRequest.ReadOnly =
    zio.aws.kendra.model.StopDataSourceSyncJobRequest.wrap(buildAwsValue())
}
object StopDataSourceSyncJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.StopDataSourceSyncJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.StopDataSourceSyncJobRequest =
      zio.aws.kendra.model.StopDataSourceSyncJobRequest(id, indexId)
    def id: DataSourceId
    def indexId: IndexId
    def getId: ZIO[Any, Nothing, DataSourceId] = ZIO.succeed(id)
    def getIndexId: ZIO[Any, Nothing, IndexId] = ZIO.succeed(indexId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.StopDataSourceSyncJobRequest
  ) extends zio.aws.kendra.model.StopDataSourceSyncJobRequest.ReadOnly {
    override val id: DataSourceId =
      zio.aws.kendra.model.primitives.DataSourceId(impl.id())
    override val indexId: IndexId =
      zio.aws.kendra.model.primitives.IndexId(impl.indexId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.StopDataSourceSyncJobRequest
  ): zio.aws.kendra.model.StopDataSourceSyncJobRequest.ReadOnly = new Wrapper(
    impl
  )
}
