package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.ResultId
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Suggestion(
    id: Option[ResultId] = None,
    value: Option[zio.aws.kendra.model.SuggestionValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.Suggestion = {
    import Suggestion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.Suggestion
      .builder()
      .optionallyWith(
        id.map(value => ResultId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(value.map(value => value.buildAwsValue()))(_.value)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.Suggestion.ReadOnly =
    zio.aws.kendra.model.Suggestion.wrap(buildAwsValue())
}
object Suggestion {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kendra.model.Suggestion] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.Suggestion = zio.aws.kendra.model
      .Suggestion(id.map(value => value), value.map(value => value.asEditable))
    def id: Option[ResultId]
    def value: Option[zio.aws.kendra.model.SuggestionValue.ReadOnly]
    def getId: ZIO[Any, AwsError, ResultId] =
      AwsError.unwrapOptionField("id", id)
    def getValue
        : ZIO[Any, AwsError, zio.aws.kendra.model.SuggestionValue.ReadOnly] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.Suggestion
  ) extends zio.aws.kendra.model.Suggestion.ReadOnly {
    override val id: Option[ResultId] = scala
      .Option(impl.id())
      .map(value => zio.aws.kendra.model.primitives.ResultId(value))
    override val value: Option[zio.aws.kendra.model.SuggestionValue.ReadOnly] =
      scala
        .Option(impl.value())
        .map(value => zio.aws.kendra.model.SuggestionValue.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.Suggestion
  ): zio.aws.kendra.model.Suggestion.ReadOnly = new Wrapper(impl)
}
