package zio.aws.kendra.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TextWithHighlights(
    text: Option[String] = None,
    highlights: Option[Iterable[zio.aws.kendra.model.Highlight]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.TextWithHighlights = {
    import TextWithHighlights.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.TextWithHighlights
      .builder()
      .optionallyWith(text.map(value => value: java.lang.String))(_.text)
      .optionallyWith(
        highlights.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.highlights)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.TextWithHighlights.ReadOnly =
    zio.aws.kendra.model.TextWithHighlights.wrap(buildAwsValue())
}
object TextWithHighlights {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.TextWithHighlights
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.TextWithHighlights =
      zio.aws.kendra.model.TextWithHighlights(
        text.map(value => value),
        highlights.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def text: Option[String]
    def highlights: Option[List[zio.aws.kendra.model.Highlight.ReadOnly]]
    def getText: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("text", text)
    def getHighlights
        : ZIO[Any, AwsError, List[zio.aws.kendra.model.Highlight.ReadOnly]] =
      AwsError.unwrapOptionField("highlights", highlights)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.TextWithHighlights
  ) extends zio.aws.kendra.model.TextWithHighlights.ReadOnly {
    override val text: Option[String] =
      scala.Option(impl.text()).map(value => value: String)
    override val highlights
        : Option[List[zio.aws.kendra.model.Highlight.ReadOnly]] = scala
      .Option(impl.highlights())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.Highlight.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.TextWithHighlights
  ): zio.aws.kendra.model.TextWithHighlights.ReadOnly = new Wrapper(impl)
}
