package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{Timestamp, ThesaurusName, ThesaurusId}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ThesaurusSummary(
    id: Option[ThesaurusId] = None,
    name: Option[ThesaurusName] = None,
    status: Option[zio.aws.kendra.model.ThesaurusStatus] = None,
    createdAt: Option[Timestamp] = None,
    updatedAt: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.ThesaurusSummary = {
    import ThesaurusSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.ThesaurusSummary
      .builder()
      .optionallyWith(
        id.map(value => ThesaurusId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        name.map(value => ThesaurusName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.ThesaurusSummary.ReadOnly =
    zio.aws.kendra.model.ThesaurusSummary.wrap(buildAwsValue())
}
object ThesaurusSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.ThesaurusSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.ThesaurusSummary =
      zio.aws.kendra.model.ThesaurusSummary(
        id.map(value => value),
        name.map(value => value),
        status.map(value => value),
        createdAt.map(value => value),
        updatedAt.map(value => value)
      )
    def id: Option[ThesaurusId]
    def name: Option[ThesaurusName]
    def status: Option[zio.aws.kendra.model.ThesaurusStatus]
    def createdAt: Option[Timestamp]
    def updatedAt: Option[Timestamp]
    def getId: ZIO[Any, AwsError, ThesaurusId] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, ThesaurusName] =
      AwsError.unwrapOptionField("name", name)
    def getStatus: ZIO[Any, AwsError, zio.aws.kendra.model.ThesaurusStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.ThesaurusSummary
  ) extends zio.aws.kendra.model.ThesaurusSummary.ReadOnly {
    override val id: Option[ThesaurusId] = scala
      .Option(impl.id())
      .map(value => zio.aws.kendra.model.primitives.ThesaurusId(value))
    override val name: Option[ThesaurusName] = scala
      .Option(impl.name())
      .map(value => zio.aws.kendra.model.primitives.ThesaurusName(value))
    override val status: Option[zio.aws.kendra.model.ThesaurusStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.kendra.model.ThesaurusStatus.wrap(value))
    override val createdAt: Option[Timestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.kendra.model.primitives.Timestamp(value))
    override val updatedAt: Option[Timestamp] = scala
      .Option(impl.updatedAt())
      .map(value => zio.aws.kendra.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.ThesaurusSummary
  ): zio.aws.kendra.model.ThesaurusSummary.ReadOnly = new Wrapper(impl)
}
