package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.Timestamp
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class TimeRange(
    startTime: Option[Timestamp] = None,
    endTime: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.TimeRange = {
    import TimeRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.TimeRange
      .builder()
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.TimeRange.ReadOnly =
    zio.aws.kendra.model.TimeRange.wrap(buildAwsValue())
}
object TimeRange {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kendra.model.TimeRange] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.TimeRange = zio.aws.kendra.model
      .TimeRange(startTime.map(value => value), endTime.map(value => value))
    def startTime: Option[Timestamp]
    def endTime: Option[Timestamp]
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.TimeRange
  ) extends zio.aws.kendra.model.TimeRange.ReadOnly {
    override val startTime: Option[Timestamp] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.kendra.model.primitives.Timestamp(value))
    override val endTime: Option[Timestamp] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.kendra.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.TimeRange
  ): zio.aws.kendra.model.TimeRange.ReadOnly = new Wrapper(impl)
}
